/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dplp.nokia.pcsuite.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;

public class StringManipulator {
    private static final char QUOTE_CHAR = '\\';
    private static final String REP_CHARS_ = "<>&\n";
    private static final String[] REP_STRINGS_ = new String[]{"&lt;", "&gt;", "&amp;", "<br>"};

    private StringManipulator() {
    }

    public static String substitute(String text, String oldString, String newString) {
        String begin = "";
        String end = "";
        int len = oldString.length();
        int beginPtr = text.indexOf(oldString);
        while (beginPtr > -1) {
            begin = text.substring(0, beginPtr);
            end = text.substring(beginPtr + len);
            text = String.valueOf(begin) + newString + end;
            beginPtr = text.indexOf(oldString);
        }
        return text;
    }

    public static String[] getComponents(String text, char delimiter) {
        LinkedList<String> components = new LinkedList<String>();
        StringBuffer buffer = new StringBuffer();
        boolean delimited = false;
        int i = 0;
        while (i < text.length()) {
            char curChar = text.charAt(i);
            if (Character.isWhitespace(curChar) && !delimited) {
                if (buffer.toString().length() > 0) {
                    components.add(buffer.toString());
                }
                buffer = new StringBuffer();
            } else if (curChar == delimiter && delimited) {
                delimited = false;
                if (buffer.toString().length() > 0) {
                    components.add(buffer.toString());
                }
                buffer = new StringBuffer();
            } else if (Character.isWhitespace(curChar) && delimited) {
                buffer.append(curChar);
            } else if (curChar == delimiter && !delimited) {
                delimited = true;
            } else {
                buffer.append(curChar);
            }
            ++i;
        }
        if (buffer.toString().length() > 0) {
            components.add(buffer.toString());
        }
        return components.toArray(new String[0]);
    }

    public static String[] combineClassPaths(String[] emulatorClassPath, String userClassPath) {
        Vector<String> wholeClassPath = new Vector<String>((Collection)Arrays.asList(emulatorClassPath));
        wholeClassPath.add(userClassPath);
        return wholeClassPath.toArray(new String[0]);
    }

    public static String[] combineClassPaths(File[] emulatorClassPath, String userClassPath) {
        Vector<String> wholeClassPath = new Vector<String>();
        int i = 0;
        while (i < emulatorClassPath.length) {
            wholeClassPath.add(emulatorClassPath[i].getAbsolutePath());
            ++i;
        }
        wholeClassPath.add(userClassPath);
        return wholeClassPath.toArray(new String[0]);
    }

    public static String getClassPathString(File[] class_path) {
        String ret = "";
        int i = 0;
        while (i < class_path.length) {
            ret = String.valueOf(ret) + class_path[i].getAbsolutePath();
            if (i + 1 < class_path.length) {
                ret = String.valueOf(ret) + File.pathSeparator;
            }
            ++i;
        }
        return ret;
    }

    public static File[] getClassPathAsFiles(String[] classPath) {
        File[] files = new File[classPath.length];
        int i = 0;
        while (i < classPath.length) {
            files[i] = new File(classPath[i]);
            ++i;
        }
        return files;
    }

    public static URL[] getClassPathAsURLs(String[] classPath) {
        File[] files = StringManipulator.getClassPathAsFiles(classPath);
        URL[] urls = new URL[files.length];
        int i = 0;
        while (i < files.length) {
            try {
                urls[i] = files[i].toURL();
            }
            catch (MalformedURLException e) {
                System.out.println("Error converting path to URL: " + e.toString());
            }
            ++i;
        }
        return urls;
    }

    public static URL[] getClassPathAsURLs(File[] class_path) {
        URL[] urls = new URL[class_path.length];
        int i = 0;
        while (i < class_path.length) {
            try {
                urls[i] = class_path[i].toURL();
            }
            catch (MalformedURLException e) {
                System.out.println("Error converting path to URL: " + e.toString());
            }
            ++i;
        }
        return urls;
    }

    public static String toHtml(String s) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            block3: {
                int c = 0;
                while (c < REP_CHARS_.length()) {
                    if (s.charAt(i) == REP_CHARS_.charAt(c)) {
                        buf.append(REP_STRINGS_[c]);
                        break block3;
                    }
                    ++c;
                }
                buf.append(s.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }

    public static String unquote(String s) {
        StringBuffer buf = new StringBuffer();
        boolean quoted = false;
        int i = 0;
        while (i < s.length()) {
            if (quoted) {
                buf.append(s.charAt(i) == 'n' ? (char)'\n' : s.charAt(i));
                quoted = false;
            } else if (s.charAt(i) == '\\') {
                quoted = true;
            } else {
                buf.append(s.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }
}

