/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class TemporaryFileManager {
    public static final TemporaryFileManager instance = new TemporaryFileManager();
    private ArrayList tempFiles = new ArrayList();

    private TemporaryFileManager() {
        Runtime.getRuntime().addShutdownHook(new CleanupThread());
    }

    public File createTempDirectory(String prefix, String suffix) throws IOException {
        return this.createTempDirectory(prefix, suffix, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempDirectory(String prefix, String suffix, File directory) throws IOException {
        File file = null;
        ArrayList arrayList = this.tempFiles;
        synchronized (arrayList) {
            file = File.createTempFile(prefix, suffix, directory);
            file.delete();
            file.mkdir();
            this.tempFiles.add(file);
        }
        return file;
    }

    public File createTempFile(String prefix, String suffix) throws IOException {
        return this.createTempFile(prefix, suffix, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File file = null;
        ArrayList arrayList = this.tempFiles;
        synchronized (arrayList) {
            file = File.createTempFile(prefix, suffix, directory);
            file.deleteOnExit();
            this.tempFiles.add(file);
        }
        return file;
    }

    private class CleanupThread
    extends Thread {
        private CleanupThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList arrayList = TemporaryFileManager.this.tempFiles;
            synchronized (arrayList) {
                for (File file : TemporaryFileManager.this.tempFiles) {
                    this.doDelete(file);
                }
            }
        }

        private void doDelete(File file) {
            if (file.isFile()) {
                try {
                    file.delete();
                }
                catch (Throwable throwable) {}
            } else {
                File[] files = file.listFiles();
                if (files != null) {
                    int i = 0;
                    while (i < files.length) {
                        File child = files[i];
                        this.doDelete(child);
                        ++i;
                    }
                }
                try {
                    file.delete();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

