/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.library;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.library.config.LibrarySpecification;
import org.eclipse.mtj.core.version.Version;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MtjCoreLibraryPlugin
extends Plugin {
    public static final String LIBRARY_TYPE_CONFIGURATION = "configuration";
    public static final String LIBRARY_TYPE_PROFILE = "profile";
    public static final String LIBRARY_TYPE_SERVICE_API = "api";
    public static final String J2ME_LIBRARIES_ID = "libraries";
    private LibrarySpecification[] librarySpecs;
    private static MtjCoreLibraryPlugin plugin;

    public MtjCoreLibraryPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static MtjCoreLibraryPlugin getDefault() {
        return plugin;
    }

    public static List<LibrarySpecification> getCorrLibrarySpecifications(File libraryFile) throws CoreException {
        LibrarySpecification[] libs = MtjCoreLibraryPlugin.getLibrarySpecifications();
        BasicEList list = new BasicEList();
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(libraryFile);
                int i = 0;
                while (i < libs.length) {
                    if (zipFile.getEntry(libs[i].getClassEntry()) != null) {
                        list.add(libs[i]);
                    }
                    ++i;
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return list;
    }

    public static LibrarySpecification[] getLibrarySpecifications(File libraryFile, String libraryType) throws CoreException {
        LibrarySpecification[] libs = MtjCoreLibraryPlugin.getLibrarySpecifications();
        ArrayList<LibrarySpecification> list = new ArrayList<LibrarySpecification>();
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(libraryFile);
                int i = 0;
                while (i < libs.length) {
                    if (libs[i].getType().equals(libraryType) && zipFile.getEntry(libs[i].getClassEntry()) != null) {
                        list.add(libs[i]);
                    }
                    ++i;
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        LibrarySpecification[] ret = new LibrarySpecification[list.size()];
        int i = 0;
        while (i < list.size()) {
            ret[i] = (LibrarySpecification)list.get(i);
            ++i;
        }
        return ret;
    }

    public static LibrarySpecification[] getLibrarySpecifications() throws CoreException {
        MtjCoreLibraryPlugin plugin = MtjCoreLibraryPlugin.getDefault();
        if (plugin.librarySpecs == null) {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(MtjCorePlugin.getId(), J2ME_LIBRARIES_ID);
            IConfigurationElement[] configElements = point.getConfigurationElements();
            plugin.librarySpecs = new LibrarySpecification[configElements.length];
            int i = 0;
            while (i < configElements.length) {
                plugin.librarySpecs[i] = MtjCoreLibraryPlugin.createComponentSpecification(configElements[i]);
                ++i;
            }
        }
        return plugin.librarySpecs;
    }

    private static LibrarySpecification createComponentSpecification(IConfigurationElement element) throws CoreException {
        String id = element.getAttribute("id");
        String type = element.getAttribute("type");
        String name = element.getAttribute("name");
        String label = element.getAttribute("label");
        String versionString = element.getAttribute("version");
        Version version = new Version(versionString);
        String binFile = element.getAttribute("binFile");
        String classEntry = element.getAttribute("classEntry");
        String sourceFile = element.getAttribute("sourceFile");
        String javadocFile = element.getAttribute("javadocFile");
        String fileNameList = element.getAttribute("fileNameList");
        LibrarySpecification specification = new LibrarySpecification();
        specification.setIdentifier(id);
        specification.setType(type);
        specification.setName(name);
        specification.setLabel(label);
        specification.setVersion(version);
        specification.setClassEntry(classEntry);
        specification.setBinFile(binFile);
        specification.setSourceFile(sourceFile);
        specification.setJavadocFile(javadocFile);
        specification.setFileNameList(fileNameList);
        return specification;
    }
}

