/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.ui.preferences.view;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.mtj.core.ui.preferences.model.ExtensionImplNode;
import org.eclipse.mtj.core.ui.util.GridUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MTJProviderViewUI {
    protected ArrayList _tableData = new ArrayList();
    private Table _tableList;
    private TableViewer tableViewer;
    private Button _moveUp;
    private Button _moveDown;
    private Button _selAll;
    private Button _unselAll;
    private Button _showDetail;
    private Label _description;
    private Label _label;
    private Label _labelMessage;
    private Control _control;
    private String[] columns;
    private Composite result;

    public MTJProviderViewUI(String[] _columns) {
        this.columns = _columns;
    }

    public Control createControl(Composite parent) {
        Composite composite = this.createContainer(parent);
        this._description = new Label(composite, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this._description.setLayoutData((Object)data);
        this.createTableViewer(composite);
        this._tableList = this.tableViewer.getTable();
        Composite buttonWidget = new Composite(composite, 0);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.horizontalIndent = 20;
        data.verticalAlignment = 4;
        buttonWidget.setLayoutData((Object)data);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 1;
        blayout.marginHeight = 25;
        buttonWidget.setLayout((Layout)blayout);
        this._moveUp = this.createButton(buttonWidget, Messages.MTJProviderViewUI_Up);
        this._moveDown = this.createButton(buttonWidget, Messages.MTJProviderViewUI_Down);
        this._selAll = this.createButton(buttonWidget, Messages.MTJProviderViewUI_SelectAll);
        this._unselAll = this.createButton(buttonWidget, Messages.MTJProviderViewUI_UnSelect);
        this._showDetail = this.createButton(buttonWidget, Messages.MTJProviderViewUI_Info);
        this._moveUp.setEnabled(false);
        this._moveDown.setEnabled(false);
        this._labelMessage = new Label(composite, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 1;
        this._labelMessage.setLayoutData((Object)data);
        this._control = composite;
        this.setDescription(Messages.MTJProviderViewUI_MtjCoreServiceProviders);
        this.result = composite;
        return composite;
    }

    public Composite getControl() {
        return this.result;
    }

    private Composite createContainer(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 15;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        data.heightHint = 350;
        data.widthHint = 350;
        result.setLayoutData((Object)data);
        return result;
    }

    private void createTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68388);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = GridUtil.createFill();
        data.heightHint = 50;
        data.widthHint = 100;
        table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        CellEditor[] cellEditors = new CellEditor[this.columns.length];
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setText(Messages.MTJProviderViewUI_Name);
        nameColumn.setWidth(60);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(120));
        cellEditors[0] = new TextCellEditor((Composite)table);
        TableColumn vendorColumn = new TableColumn(table, 16384);
        vendorColumn.setText(Messages.MTJProviderViewUI_Vendor);
        vendorColumn.setWidth(60);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(110));
        TableColumn versionColumn = new TableColumn(table, 16384);
        versionColumn.setText(Messages.MTJProviderViewUI_Version);
        versionColumn.setWidth(10);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(40));
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setColumnProperties(this.columns);
    }

    private Button createButton(Composite parent, String label) {
        Button btn = new Button(parent, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        btn.setLayoutData((Object)data);
        btn.setText(label);
        return btn;
    }

    protected void setDescription(String descr) {
        this._description.setText(descr);
    }

    protected void setLabel(String label) {
        this._label.setText(label);
    }

    protected void createColumnDataFromString(String filter, ArrayList _data) {
    }

    protected void loadColumnData(String _filter, ArrayList _data, Table _list, IPreferenceStore store) {
        int idx = 0;
        while (idx < this._tableList.getItemCount()) {
            TableItem _item = this._tableList.getItem(idx);
            ExtensionImplNode _cd = (ExtensionImplNode)_item.getData();
            MtjExtension _m = null;
            if (_cd.getImpl() instanceof MtjExtension) {
                _m = (MtjExtension)_cd.getImpl();
                _item.setChecked(_m.isActive());
            }
            ++idx;
        }
    }

    protected void saveColumnData(String _filter, ArrayList _data, Table _list, IPreferenceStore store) {
    }

    public Button get_moveDown() {
        return this._moveDown;
    }

    public void set_moveDown(Button down) {
        this._moveDown = down;
    }

    public Button get_moveUp() {
        return this._moveUp;
    }

    public void set_moveUp(Button up) {
        this._moveUp = up;
    }

    public Button get_selAll() {
        return this._selAll;
    }

    public void set_selAll(Button all) {
        this._selAll = all;
    }

    public Button get_showDetail() {
        return this._showDetail;
    }

    public void set_showDetail(Button detail) {
        this._showDetail = detail;
    }

    public Button get_unselAll() {
        return this._unselAll;
    }

    public void set_unselAll(Button all) {
        this._unselAll = all;
    }

    public ArrayList get_tableData() {
        return this._tableData;
    }

    public void set_tableData(ArrayList data) {
        this._tableData = data;
    }

    public Table get_tableList() {
        return this._tableList;
    }

    public void set_tableList(Table list) {
        this._tableList = list;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setTableViewer(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public Label get_description() {
        return this._description;
    }

    public void set_description(Label _description) {
        this._description = _description;
    }

    public Label get_label() {
        return this._label;
    }

    public void set_label(Label _label) {
        this._label = _label;
    }

    public Label get_labelMessage() {
        return this._labelMessage;
    }

    public void set_labelMessage(Label message) {
        this._labelMessage = message;
    }

    protected boolean ifAllItemsIsUnchecked() {
        int idx = 0;
        while (idx < this._tableList.getItemCount()) {
            if (this._tableList.getItem(idx).getChecked()) {
                return false;
            }
            ++idx;
        }
        return true;
    }
}

