/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.ui.preferences.view;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.core.ui.preferences.model.MtjProjectContentProvider;
import org.eclipse.mtj.core.ui.preferences.model.MtjProjectLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class ProjectScopeDialog
extends StatusDialog {
    private CheckboxTableViewer fTableViewer;
    private Set fProjectsWithSpecifics;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private static final String DIALOG_SETTINGS_SHOW_ALL = "ProjectScopeDialog.show_all";
    private ViewerFilter fFilter;
    private IJavaProject[] selectionResult = null;
    private IJavaProject[] fSourceProjects = null;
    private boolean doFilter = false;

    public ProjectScopeDialog(Shell shell, String title, Set projectsWithSpecifics, IJavaProject[] _projects) {
        super(shell);
        this.setTitle(title);
        this.fProjectsWithSpecifics = projectsWithSpecifics;
        this.fSourceProjects = _projects;
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.fFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ProjectScopeDialog.this.fProjectsWithSpecifics.contains(element);
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        composite.setFont(font);
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] _selected = ((IStructuredSelection)event.getSelection()).toArray();
                ProjectScopeDialog.this.doSelectionChanged(_selected);
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                CheckboxTableViewer source = (CheckboxTableViewer)e.getSource();
                int ix = 0;
                while (ix < source.getTable().getItems().length) {
                    if (((IJavaProject)source.getTable().getItems()[ix].getData()).equals((IJavaProject)e.getElement())) {
                        ProjectScopeDialog.this.fTableViewer.getTable().select(ix);
                    }
                    ++ix;
                }
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 250;
        data.widthHint = 300;
        this.fTableViewer.getTable().setLayoutData((Object)data);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new MtjProjectLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new MtjProjectContentProvider(this.fProjectsWithSpecifics));
        this.fTableViewer.getControl().setFont(font);
        JavaPlugin.getDefault().getDialogSettings();
        this.updateFilter(this.doFilter);
        this.fTableViewer.setInput((Object)parent);
        this.fTableViewer.getTable().setSelection(0);
        this.doSelectionChanged(this.fTableViewer.getTable().getSelection());
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        return control;
    }

    protected void updateFilter(boolean selected) {
        if (selected) {
            this.fTableViewer.addFilter(this.fFilter);
        } else {
            this.fTableViewer.removeFilter(this.fFilter);
        }
        JavaPlugin.getDefault().getDialogSettings().put(DIALOG_SETTINGS_SHOW_ALL, !selected);
    }

    protected void okPressed() {
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>();
        try {
            int idx = 0;
            while (idx < this.fTableViewer.getTable().getItemCount()) {
                TableItem _item = this.fTableViewer.getTable().getItem(idx);
                if (_item.getChecked()) {
                    IJavaProject _jp = (IJavaProject)_item.getData();
                    projects.add(_jp);
                }
                ++idx;
            }
            if (projects.size() > 0) {
                Object[] _obj = projects.toArray();
                IJavaProject[] _prj = new IJavaProject[_obj.length];
                int i = 0;
                while (i < _obj.length) {
                    _prj[i] = (IJavaProject)_obj[i];
                    ++i;
                }
                this.setSelectionResult(_prj);
            } else {
                this.setSelectionResult(null);
            }
        }
        catch (Exception ex) {
            MtjCorePlugin.getDefault();
            MtjCoreUiPlugin.displayError(MtjCorePlugin.getActiveShell(), 1, 1, Messages.ProjectScopeDialog_Error, Messages.ProjectScopeDialog_ErrorOccurred, ex);
        }
        super.okPressed();
    }

    private void doSelectionChanged(Object[] objects) {
        if (objects.length != 1) {
            this.updateStatus((IStatus)new StatusInfo(4, ""));
        } else {
            this.updateStatus((IStatus)new StatusInfo());
        }
    }

    private void setSelectionResult(IJavaProject[] obj) {
        this.selectionResult = obj;
    }

    public IJavaProject[] getSelectionResult() {
        return this.selectionResult;
    }
}

