/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;

public class ColumnData {
    private String _name;
    private boolean _visible = false;
    private Object _obj;

    public ColumnData() {
    }

    public ColumnData(String name, boolean visible) {
        this._name = name;
        this._visible = visible;
    }

    public ColumnData(String name, boolean visible, Object obj) {
        this._name = name;
        this._visible = visible;
        this._obj = obj;
    }

    public static ArrayList createColumnData(String preferenceKey, String defaultColumns) {
        String preferenceColumns = MtjCoreUiPlugin.getDefault().getPreferenceStore().getString(preferenceKey);
        if (preferenceColumns == null || preferenceColumns.length() == 0) {
            preferenceColumns = defaultColumns;
        }
        return ColumnData.createColumnDataFromString(preferenceColumns);
    }

    public static ArrayList createColumnDataFromString(String preferenceColumns) {
        ArrayList columnDataList = null;
        if (preferenceColumns != null && !preferenceColumns.equals("")) {
            int count = 1;
            String _break = "|";
            int i = 0;
            while (i < preferenceColumns.length()) {
                char c = preferenceColumns.charAt(i);
                if (_break.indexOf(c) != -1) {
                    ++count;
                }
                ++i;
            }
            columnDataList = new ArrayList(count);
            int idx = 0;
            while (idx != -1) {
                String columnDataTemplate;
                idx = preferenceColumns.indexOf("|");
                if (idx != -1) {
                    columnDataTemplate = preferenceColumns.substring(0, idx);
                    preferenceColumns = preferenceColumns.substring(idx + 1);
                } else {
                    columnDataTemplate = preferenceColumns;
                }
                columnDataList = ColumnData.addColumnData(columnDataTemplate, columnDataList);
            }
        }
        return columnDataList;
    }

    private static ArrayList addColumnData(String columnTemplate, ArrayList _list) {
        String columnName = "";
        boolean visible = false;
        int idx = columnTemplate.indexOf("=");
        if (idx != -1) {
            columnName = columnTemplate.substring(0, idx);
            columnTemplate = columnTemplate.substring(idx + 1);
        } else {
            columnName = columnTemplate;
        }
        visible = columnTemplate.equals("1");
        ColumnData _colData = new ColumnData(columnName, visible);
        _list.add(_colData);
        return _list;
    }

    public static void setColumns(List newList, List currentList, String preferenceKey, IPreferenceStore store) {
        currentList.clear();
        currentList.addAll(newList);
        ColumnData.setColumns(currentList, preferenceKey, store);
    }

    public static void setColumns(List currentList, String preferenceKey, IPreferenceStore store) {
        String columns = ColumnData.getPreferenceString(currentList);
        store.setValue(preferenceKey, columns);
    }

    public static String getPreferenceString(List currentList) {
        String columns = "";
        String columnName = "";
        int i = 0;
        while (i < currentList.size()) {
            ColumnData columnData = (ColumnData)currentList.get(i);
            columnName = columnData.getName();
            columns = columnData.getVisible() ? String.valueOf(columns) + "|" + columnName + "=1" : String.valueOf(columns) + "|" + columnName + "=0";
            ++i;
        }
        return columns.trim();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setObject(Object obj) {
        this._obj = obj;
    }

    public Object getObject() {
        return this._obj;
    }

    public boolean getVisible() {
        return this._visible;
    }

    public void setVisible(boolean visible) {
        this._visible = visible;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('(');
        if (this._obj != null) {
            result.append(String.valueOf(this._obj.getClass().getName()) + ",");
        }
        result.append(" name: ");
        result.append(this._name);
        result.append(", visible: ");
        result.append(this._visible);
        result.append(')');
        return result.toString();
    }
}

