/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dm.preferences;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.ui.util.DialogController;
import org.eclipse.mtj.extension.dm.Messages;
import org.eclipse.mtj.extension.dm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.dm.ui.preferences.DeviceInfoComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DeviceInfoController
implements DialogController {
    private MtjServiceHandler mtjServiceHandler;
    private Device selectedDevice;
    private DeviceInfoComposite composite;
    private TableViewer apiTableViewer;

    public DeviceInfoController(Device selectedDevice, MtjServiceHandler mtjServiceHandler, DeviceInfoComposite composite) {
        this.composite = composite;
        this.selectedDevice = selectedDevice;
        this.mtjServiceHandler = mtjServiceHandler;
        this.apiTableViewer = composite.getOptionalApiTableViewer();
        this.setData();
    }

    private void setData() {
        this.composite.getDeviceNameLabel().setText(this.selectedDevice.getName());
        this.composite.getDeviceDescriptionLabel().setText(this.selectedDevice.getDescription());
        EList l = this.selectedDevice.getRuntimePlatformDefinitions();
        RuntimePlatformDefinition rpd = (RuntimePlatformDefinition)l.get(0);
        this.createProfile(rpd);
        this.createConfiguration(rpd);
        this.createServiceApi(rpd);
    }

    public static Button createRadioButton(Group parent, String label) {
        Button button = new Button((Composite)parent, 32);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        return button;
    }

    private boolean containsProfile(String profileName, String profileVersion, Iterator iterator) {
        while (iterator.hasNext()) {
            DeviceProfile dp = (DeviceProfile)iterator.next();
            if (!dp.getName().equals(profileName) || !dp.getVersion().equals(profileVersion)) continue;
            return true;
        }
        return false;
    }

    private boolean containsConfiguration(String configurationName, String configurationVersion, Iterator iterator) {
        while (iterator.hasNext()) {
            DeviceConfiguration dc = (DeviceConfiguration)iterator.next();
            if (!dc.getName().equals(configurationName) || !dc.getVersion().equals(configurationVersion)) continue;
            return true;
        }
        return false;
    }

    private void createProfile(RuntimePlatformDefinition rpd) {
        EList l = rpd.getDeviceProfiles();
        Group group = this.composite.getProfileGroup();
        if (!this.containsProfile("MIDP", "1.0", l.iterator())) {
            Button button = DeviceInfoController.createRadioButton(group, "MIDP 1.0");
            button.setEnabled(false);
        }
        int i = 0;
        while (i < l.size()) {
            DeviceProfile dp = (DeviceProfile)l.get(i);
            String dps = String.valueOf(dp.getName()) + " " + dp.getVersion();
            Button button = DeviceInfoController.createRadioButton(group, dps);
            button.setSelection(true);
            ++i;
        }
    }

    private void createConfiguration(RuntimePlatformDefinition rpd) {
        EList l = rpd.getDeviceConfigurations();
        Group group = this.composite.getConfigGroup();
        if (!this.containsConfiguration("CLDC", "1.0", l.iterator())) {
            Button button = DeviceInfoController.createRadioButton(group, "CLDC 1.0");
            button.setEnabled(false);
        }
        int i = 0;
        while (i < l.size()) {
            DeviceConfiguration dc = (DeviceConfiguration)l.get(i);
            String dcs = String.valueOf(dc.getName()) + " " + dc.getVersion();
            Button button = DeviceInfoController.createRadioButton(group, dcs);
            button.setSelection(true);
            ++i;
        }
    }

    private void createServiceApi(RuntimePlatformDefinition rpd) {
        private class EListContentProvider
        implements IStructuredContentProvider {
            EListContentProvider() {
            }

            public Object[] getElements(Object o) {
                if (o instanceof EList) {
                    return ((EList)o).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
        this.apiTableViewer.setContentProvider((IContentProvider)new EListContentProvider());
        private class Tlp
        extends LabelProvider
        implements ITableLabelProvider {
            Tlp() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof ServiceApi) {
                    ServiceApi api = (ServiceApi)element;
                    if (columnIndex == 0) {
                        return api.getName();
                    }
                    if (columnIndex == 1) {
                        return api.getVersion();
                    }
                    if (columnIndex == 2) {
                        return api.getDescription();
                    }
                }
                return null;
            }
        }
        this.apiTableViewer.setLabelProvider((IBaseLabelProvider)new Tlp());
        DeviceInfoController.createTableColumn(this.apiTableViewer.getTable(), 0, 60, Messages.DeviceInfoController_Name);
        DeviceInfoController.createTableColumn(this.apiTableViewer.getTable(), 1, 40, Messages.DeviceInfoController_Version);
        DeviceInfoController.createTableColumn(this.apiTableViewer.getTable(), 2, 300, Messages.DeviceInfoController_Description);
        EList rpApiList = rpd.getServiceApis();
        this.apiTableViewer.setInput((Object)rpApiList);
    }

    private static void createTableColumn(Table table, int colIndex, int weight, String header) {
        TableColumn tableColumn = new TableColumn(table, 0, colIndex);
        tableColumn.setResizable(true);
        tableColumn.setText(header);
        tableColumn.setWidth(weight);
    }

    public void handleOK() {
    }
}

