/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dm.preferences;

import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.ui.util.CompositeDialog;
import org.eclipse.mtj.core.ui.util.DialogController;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.dm.Messages;
import org.eclipse.mtj.extension.dm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.dm.preferences.DeviceInfoController;
import org.eclipse.mtj.extension.dm.preferences.DevicePlatformInfoController;
import org.eclipse.mtj.extension.dm.ui.preferences.AddDevicePlatformDialog2;
import org.eclipse.mtj.extension.dm.ui.preferences.DeviceInfoComposite;
import org.eclipse.mtj.extension.dm.ui.preferences.DevicePlatformInfoComposite;
import org.eclipse.mtj.extension.dm.ui.preferences.DevicePlatformListComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DevicePlatformListController
implements ISelectionChangedListener,
SelectionListener {
    private static Logger log = Logger.getLogger(DevicePlatformListController.class.getName());
    private DevicePlatformListComposite composite;
    private MtjServiceHandler mtjServiceHandler = new MtjServiceHandler();
    private DevicePlatform selectedDevicePlatform;
    private Device selectedDevice;
    private static Shell containerShell = new Shell();
    private Button addButton;
    private Button editRuntimeButton;
    private Button editDeviceButton;
    private Button removeButton;
    private TableViewer devicePlatformTableViewer;
    private TableViewer deviceTableViewer;

    public DevicePlatformListController(DevicePlatformListComposite composite) {
        this.composite = composite;
        this.addButton = composite.getAddButton();
        this.editRuntimeButton = composite.getEditRuntimeButton();
        this.editDeviceButton = composite.getEditDeviceButton();
        this.removeButton = composite.getRemoveButton();
        this.devicePlatformTableViewer = composite.getDevicePlatformTableViewer();
        this.deviceTableViewer = composite.getDeviceTableViewer();
        this.setData();
        this.addListener();
        this.editRuntimeButton.setText(Messages.DevicePlatformListController_Info);
    }

    private void addListener() {
        this.devicePlatformTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.deviceTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.addButton.addSelectionListener((SelectionListener)this);
        this.editDeviceButton.addSelectionListener((SelectionListener)this);
        this.editRuntimeButton.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
    }

    private static TableColumn createTableColumn(String title, Table table, int index, int widthHint) {
        TableColumn tableColumn = new TableColumn(table, 0, index);
        tableColumn.setResizable(true);
        tableColumn.setWidth(widthHint);
        tableColumn.setText(title);
        return tableColumn;
    }

    private void setData() {
        private class ArrayContentProvider
        implements IStructuredContentProvider {
            ArrayContentProvider() {
            }

            public Object[] getElements(Object o) {
                if (o instanceof DevicePlatform[]) {
                    return (Object[])o;
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
        this.devicePlatformTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        private class Dtlp
        extends LabelProvider
        implements ITableLabelProvider {
            Dtlp() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof DevicePlatform) {
                    DevicePlatform dp = (DevicePlatform)element;
                    if (columnIndex == 0) {
                        return dp.getName();
                    }
                    if (columnIndex == 1) {
                        return dp.getVersion();
                    }
                    if (columnIndex == 2) {
                        return dp.getVendor();
                    }
                }
                return null;
            }
        }
        this.devicePlatformTableViewer.setLabelProvider((IBaseLabelProvider)new Dtlp());
        DevicePlatformListController.createTableColumn(Messages.DevicePlatformListController_Name, this.devicePlatformTableViewer.getTable(), 0, 220);
        DevicePlatformListController.createTableColumn(Messages.DevicePlatformListController_Version, this.devicePlatformTableViewer.getTable(), 1, 40);
        DevicePlatformListController.createTableColumn(Messages.DevicePlatformListController_Vendor, this.devicePlatformTableViewer.getTable(), 2, 100);
        private class EListContentProvider
        implements IStructuredContentProvider {
            EListContentProvider() {
            }

            public Object[] getElements(Object o) {
                if (o instanceof EList) {
                    return ((EList)o).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
        this.deviceTableViewer.setContentProvider((IContentProvider)new EListContentProvider());
        private class Tlp
        extends LabelProvider
        implements ITableLabelProvider {
            Tlp() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof Device) {
                    Device device = (Device)element;
                    if (columnIndex == 0) {
                        return device.getName();
                    }
                    if (columnIndex == 1) {
                        return device.getDescription();
                    }
                }
                return null;
            }
        }
        this.deviceTableViewer.setLabelProvider((IBaseLabelProvider)new Tlp());
        DevicePlatformListController.createTableColumn(Messages.DevicePlatformListController_Name, this.deviceTableViewer.getTable(), 0, 160);
        DevicePlatformListController.createTableColumn(Messages.DevicePlatformListController_Description, this.deviceTableViewer.getTable(), 1, 160);
        this.devicePlatformTableViewer.setInput((Object)this.mtjServiceHandler.getDevicePlatforms());
        this.editRuntimeButton.setEnabled(false);
        this.editDeviceButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void devicePlatformTableEvent() {
        IStructuredSelection structured;
        Object element;
        ISelection selection = this.devicePlatformTableViewer.getSelection();
        if (!selection.isEmpty() && (element = (structured = (IStructuredSelection)selection).getFirstElement()) instanceof DevicePlatform) {
            DevicePlatform dp;
            this.selectedDevicePlatform = dp = (DevicePlatform)element;
            EList dl = dp.getDevices();
            this.deviceTableViewer.setInput((Object)dl);
            this.editRuntimeButton.setEnabled(true);
            this.removeButton.setEnabled(true);
            this.editDeviceButton.setEnabled(false);
        }
    }

    public DevicePlatform[] getDevicePlatforms() {
        return (DevicePlatform[])this.devicePlatformTableViewer.getInput();
    }

    private void deviceTableEvent() {
        ISelection selection = this.deviceTableViewer.getSelection();
        if (!selection.isEmpty()) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            Object element = structured.getFirstElement();
            if (element instanceof Device) {
                Device d;
                this.selectedDevice = d = (Device)element;
                this.editDeviceButton.setEnabled(true);
            } else {
                this.editDeviceButton.setEnabled(false);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.devicePlatformTableViewer) {
            this.devicePlatformTableEvent();
        }
        if (event.getSource() == this.deviceTableViewer) {
            this.deviceTableEvent();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addButton) {
            this.addDevicePlatform();
        } else if (e.widget == this.editRuntimeButton) {
            this.editDevicePlatform();
        } else if (e.widget == this.editDeviceButton) {
            this.editDevice();
        } else if (e.widget == this.removeButton) {
            this.removeDevicePlatform();
        }
    }

    private void addDevicePlatform() {
        AddDevicePlatformDialog2 dialog = new AddDevicePlatformDialog2(this.composite.getShell(), Messages.DevicePlatformListController_AddMobileDevicePlatform);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            DevicePlatform[] devicePlatforms = this.mtjServiceHandler.getDevicePlatforms();
            this.devicePlatformTableViewer.setInput((Object)devicePlatforms);
            if (devicePlatforms != null) {
                this.devicePlatformTableViewer.refresh();
            }
        }
    }

    private void removeDevicePlatform() {
        IStructuredSelection ss = (IStructuredSelection)this.devicePlatformTableViewer.getSelection();
        Object o = ss.getFirstElement();
        DevicePlatform dp = (DevicePlatform)o;
        if (dp != null) {
            DeviceManagement dm = (DeviceManagement)MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_MANAGEMENT_LITERAL, null, null, true)[0];
            try {
                dm.removeDevicePlatform(dp);
            }
            catch (MtjException e) {
                e.printStackTrace();
                return;
            }
        }
        DevicePlatform[] dpa = (DevicePlatform[])this.devicePlatformTableViewer.getInput();
        DevicePlatform[] newdpa = new DevicePlatform[dpa.length - 1];
        int i = 0;
        int j = 0;
        while (i < dpa.length && j < newdpa.length) {
            if (dp != dpa[i]) {
                newdpa[j] = dpa[i];
                ++j;
            }
            ++i;
        }
        this.devicePlatformTableViewer.remove((Object)dp);
        this.devicePlatformTableViewer.setInput((Object)newdpa);
    }

    public void editDevice() {
        DeviceInfoComposite dic = new DeviceInfoComposite((Composite)containerShell);
        CompositeDialog d = CompositeDialog.createDialog((Composite)dic, (DialogController)new DeviceInfoController(this.selectedDevice, this.mtjServiceHandler, dic), (String)Messages.DevicePlatformListController_Device, (String)Messages.DevicePlatformListController_DeviceSettingsInfo);
        d.open();
    }

    private void editDevicePlatform() {
        DevicePlatformInfoComposite dpic = new DevicePlatformInfoComposite(containerShell);
        CompositeDialog d = CompositeDialog.createDialog((Composite)dpic, (DialogController)new DevicePlatformInfoController(dpic, this.selectedDevicePlatform), (String)Messages.DevicePlatformListController_DevicePlatform, (String)Messages.DevicePlatformListController_DevicePlatformInfo);
        d.open();
    }
}

