/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dpp.ui.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.ConfigurationItem;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.dpp.impl.DevicePlatformProviderImpl;
import org.eclipse.mtj.extension.dpp.ui.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AdminPage
extends Composite {
    private int fieldLength = 250;
    private int fieldHight = 20;
    TreeViewer treeViewer;
    DevicePlatform platform;

    public AdminPage(Composite parent, int style) {
        super(parent, style);
        try {
            DeviceManagement dm = (DeviceManagement)MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_MANAGEMENT_LITERAL, null, null, true)[0];
            DevicePlatform[] dp = dm.getDevicePlatforms();
            if (dp.length > 0) {
                this.init(dp[0]);
            }
        }
        catch (MtjException e) {
            e.printStackTrace();
        }
    }

    protected void init(DevicePlatform platform) {
        this.platform = platform;
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        layout.numColumns = 5;
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        for (ConfigurationItem item : platform.getConfiguration().getItems()) {
            Label label = new Label((Composite)this, 0);
            GridData gd = new GridData(1);
            gd.horizontalSpan = 1;
            label.setLayoutData((Object)gd);
            label.setText(item.getLabel() != null ? item.getLabel() : "");
            int span = 4;
            if (item.getValue() != null && (item.getValue().indexOf("\\") != -1 || item.getValue().indexOf("/") != -1)) {
                span = 1;
            }
            Text swt_text = new Text((Composite)this, 2048);
            gd = new GridData(1);
            gd.horizontalSpan = span;
            gd.widthHint = this.fieldLength;
            gd.heightHint = this.fieldHight;
            swt_text.setLayoutData((Object)gd);
            swt_text.setText(item.getValue() != null ? item.getValue() : "");
            swt_text.setToolTipText(item.getDescription() != null ? item.getDescription() : "");
            swt_text.addModifyListener((ModifyListener)new ModifyListenerImpl(item, swt_text));
            if (span != 1) continue;
            Button swt_button = new Button((Composite)this, 8);
            gd = new GridData(1);
            gd.horizontalSpan = 3;
            gd.heightHint = this.fieldHight;
            swt_button.setLayoutData((Object)gd);
            swt_button.addMouseListener((MouseListener)new DirectoryDialogMouseAdapter(swt_text));
            swt_button.setBounds(0, 0, this.fieldHight, this.fieldHight);
            swt_button.setText("...");
        }
        Label empty_row = new Label((Composite)this, 0);
        GridData gd = new GridData(1);
        gd.horizontalSpan = 5;
        empty_row.setLayoutData((Object)gd);
        empty_row.setText("");
        Button swt_button_save = new Button((Composite)this, 8);
        gd = new GridData(1);
        gd.horizontalSpan = 5;
        gd.heightHint = this.fieldHight;
        swt_button_save.setLayoutData((Object)gd);
        swt_button_save.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                AdminPage.this.buttonAction_save();
            }
        });
        swt_button_save.setBounds(0, 0, this.fieldHight, this.fieldHight);
        swt_button_save.setText(Messages.AdminPage_Save);
        Label empty_row2 = new Label((Composite)this, 0);
        gd = new GridData(1);
        gd.horizontalSpan = 5;
        empty_row2.setLayoutData((Object)gd);
        empty_row2.setText("");
        this.treeViewer = new TreeViewer((Composite)this, 4);
        gd = new GridData(1);
        gd.horizontalSpan = 5;
        gd.widthHint = 550;
        gd.heightHint = 230;
        this.treeViewer.getTree().setLayoutData((Object)gd);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeViewLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new TreeViewContentProvider());
        Object[] in = new Object[]{platform};
        this.treeViewer.setInput((Object)in);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new TreeViewSelectionChangedListener());
    }

    private void buttonAction_save() {
        try {
            DevicePlatformProviderImpl.getDefault().setDevicePlatform(this.platform);
        }
        catch (MtjException e) {
            e.printStackTrace();
        }
    }

    public class DirectoryDialogMouseAdapter
    implements MouseListener {
        Text swt_text;

        public DirectoryDialogMouseAdapter(Text swt_text) {
            this.swt_text = swt_text;
        }

        public void mouseDown(MouseEvent mouseEvent) {
            Shell shell = MtjCorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            DirectoryDialog dialog = new DirectoryDialog(shell, 4096);
            String selectedFileName = dialog.open();
            if (selectedFileName != null) {
                this.swt_text.setText(selectedFileName);
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            System.out.println();
        }

        public void mouseUp(MouseEvent e) {
            System.out.println();
        }
    }

    class ModifyListenerImpl
    implements ModifyListener {
        ConfigurationItem item;
        Text text;

        public ModifyListenerImpl(ConfigurationItem item, Text text) {
            this.item = item;
            this.text = text;
        }

        public void modifyText(ModifyEvent e) {
            this.item.setValue(this.text.getText());
        }
    }

    class TreeViewLabelProvider
    extends LabelProvider {
        TreeViewLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof DevicePlatform) {
                return String.valueOf(Messages.AdminPage_Platform) + ((DevicePlatform)obj).getName();
            }
            if (obj instanceof Device) {
                return String.valueOf(Messages.AdminPage_Device) + ((Device)obj).getName();
            }
            if (obj instanceof RuntimePlatformDefinition) {
                return String.valueOf(Messages.AdminPage_RPD) + ((RuntimePlatformDefinition)obj).getName();
            }
            if (obj instanceof DeviceProfile) {
                return String.valueOf(Messages.AdminPage_DeviceProfile) + ((DeviceProfile)obj).getName() + ", " + ((DeviceProfile)obj).getVersion();
            }
            if (obj instanceof DeviceConfiguration) {
                return String.valueOf(Messages.AdminPage_DeviceConfiguration) + ((DeviceConfiguration)obj).getName() + ", " + ((DeviceConfiguration)obj).getVersion();
            }
            if (obj instanceof ServiceApi) {
                return String.valueOf(Messages.AdminPage_ServiceApi) + ((ServiceApi)obj).getName() + ", " + ((ServiceApi)obj).getVersion();
            }
            if (obj instanceof ImplementationRef) {
                return String.valueOf(Messages.AdminPage_File) + ((ImplementationRef)obj).getFileRef();
            }
            return obj.toString();
        }

        public Image getImage(Object obj) {
            return null;
        }
    }

    class TreeViewContentProvider
    implements ITreeContentProvider {
        TreeViewContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof DevicePlatform) {
                ArrayList list = new ArrayList();
                Iterator it = ((DevicePlatform)parentElement).getDevices().iterator();
                while (it.hasNext()) {
                    list.add(it.next());
                }
                it = ((DevicePlatform)parentElement).getRuntimePlatformDefinitions().iterator();
                while (it.hasNext()) {
                    list.add(it.next());
                }
                return list.toArray();
            }
            if (parentElement instanceof Device) {
                ArrayList list = new ArrayList();
                Iterator it = ((Device)parentElement).getRuntimePlatformDefinitions().iterator();
                while (it.hasNext()) {
                    list.add(it.next());
                }
                return list.toArray();
            }
            if (parentElement instanceof RuntimePlatformDefinition) {
                ArrayList list = new ArrayList();
                Iterator it = ((RuntimePlatformDefinition)parentElement).getDeviceProfiles().iterator();
                while (it.hasNext()) {
                    list.add(it.next());
                }
                it = ((RuntimePlatformDefinition)parentElement).getServiceApis().iterator();
                while (it.hasNext()) {
                    list.add(it.next());
                }
                it = ((RuntimePlatformDefinition)parentElement).getDeviceConfigurations().iterator();
                while (it.hasNext()) {
                    list.add(it.next());
                }
                return list.toArray();
            }
            if (parentElement instanceof DeviceProfile) {
                ArrayList list = new ArrayList();
                Iterator it = ((DeviceProfile)parentElement).getServiceApis().iterator();
                while (it.hasNext()) {
                    list.add(it.next());
                }
                return list.toArray();
            }
            if (parentElement instanceof DeviceConfiguration) {
                ArrayList<ImplementationRef> list = new ArrayList<ImplementationRef>();
                list.add(((DeviceConfiguration)parentElement).getImplementation());
                return list.toArray();
            }
            if (parentElement instanceof ServiceApi) {
                ArrayList<ImplementationRef> list = new ArrayList<ImplementationRef>();
                list.add(((ServiceApi)parentElement).getImplementation());
                return list.toArray();
            }
            if (parentElement instanceof Object[]) {
                return (Object[])parentElement;
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return true;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TreeViewSelectionChangedListener
    implements ISelectionChangedListener {
        TreeViewSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() instanceof StructuredSelection && ((StructuredSelection)event.getSelection()).size() > 0) {
                ((StructuredSelection)event.getSelection()).getFirstElement();
            }
        }
    }
}

