/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dm.ui.preferences;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mtj.extension.dm.ui.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class DeviceInfoComposite
extends Composite {
    private Label rpName;
    private Label deviceName;
    private TableViewer optionalApiTableViewer;
    private Group profileGroup;
    private Group configGroup;
    private Group serviceGroup;
    protected String[] variableTargetDeviceTableColumnHeaders = new String[]{Messages.DeviceInfoComposite_Import, Messages.DeviceInfoComposite_DeviceName, Messages.DeviceInfoComposite_DevicePlatformName};
    protected ColumnLayoutData[] variableTargetDeviceTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(20), new ColumnWeightData(50), new ColumnWeightData(50)};

    public TableViewer getOptionalApiTableViewer() {
        return this.optionalApiTableViewer;
    }

    public Label getDeviceNameLabel() {
        return this.rpName;
    }

    public Label getDeviceDescriptionLabel() {
        return this.deviceName;
    }

    public Group getProfileGroup() {
        return this.profileGroup;
    }

    public Group getServiceGroup() {
        return this.serviceGroup;
    }

    public Group getConfigGroup() {
        return this.configGroup;
    }

    public DeviceInfoComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(1808));
        this.createRuntimeSelectionArea();
        this.createRuntimeDataArea();
    }

    private void createRuntimeDataArea() {
        this.createApiGroups(this);
    }

    private void createApiTableViewer(Composite parent) {
        this.optionalApiTableViewer = DeviceInfoComposite.createTable(parent, 0);
    }

    private void createApiGroups(Composite parent) {
        this.profileGroup = this.createDefaultGroup(parent, 2, false);
        this.profileGroup.setText(Messages.DeviceInfoComposite_Profiles);
        this.configGroup = this.createDefaultGroup(parent, 2, false);
        this.configGroup.setText(Messages.DeviceInfoComposite_Configurations);
        this.serviceGroup = this.createDefaultGroup(parent, 1, false);
        this.serviceGroup.setText(Messages.DeviceInfoComposite_ServiceApis);
        this.createApiTableViewer((Composite)this.serviceGroup);
    }

    public CheckboxTableViewer createTargetDeviceTable(Composite parent) {
        CheckboxTableViewer deviceTableViewer = (CheckboxTableViewer)DeviceInfoComposite.createTable(parent, 32);
        return deviceTableViewer;
    }

    private static TableViewer createTable(Composite parent, int swtType) {
        Composite tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.widthHint = 400;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)gridData);
        CheckboxTableViewer platformTableViewer = null;
        Table platformTable = null;
        if (swtType == 32) {
            platformTable = new Table(tableComposite, 2848);
            platformTableViewer = new CheckboxTableViewer(platformTable);
        } else {
            platformTable = new Table(tableComposite, 68356);
            platformTableViewer = new TableViewer(platformTable);
        }
        TableLayout tableLayout2 = new TableLayout();
        platformTable.setLayout((Layout)tableLayout2);
        platformTable.setHeaderVisible(true);
        platformTable.setLinesVisible(true);
        platformTable.setFont(parent.getFont());
        gridData = new GridData(1808);
        platformTableViewer.getControl().setLayoutData((Object)gridData);
        return platformTableViewer;
    }

    private void createRefreshArea(Composite parent) {
        Composite panel = this.createDefaultComposite(parent, 1, false);
        this.createPushButton(panel, Messages.DeviceInfoComposite_RefreshContents);
    }

    public Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        return button;
    }

    public Composite createDefaultComposite(Composite parent, int columns, boolean equalWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, equalWidth);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void createRuntimeSelectionArea() {
        Group container = this.createDefaultGroup(this, 2, false);
        container.setText(Messages.DeviceInfoComposite_Device);
        this.createLabel((Composite)container, Messages.DeviceInfoComposite_NameLabel);
        this.rpName = this.createLabel((Composite)container, "");
        this.createLabel((Composite)container, Messages.DeviceInfoComposite_DeviceLabel);
        this.deviceName = this.createLabel((Composite)container, "");
    }

    public Text createText(Composite parent, boolean editable) {
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.setEditable(editable);
        return text;
    }

    public Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)new GridData(32));
        return label;
    }

    public Group createDefaultGroup(Composite parent, int columns, boolean equalWidth) {
        Group group = new Group(parent, 4);
        GridLayout layout = new GridLayout(columns, equalWidth);
        group.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        group.setLayoutData((Object)data);
        return group;
    }
}

