/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dm.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;

public class TargetDeviceContentProvider
implements ITreeContentProvider {
    private Viewer myViewer;
    private Object myInput;

    public TargetDeviceContentProvider(Viewer viewer) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = null;
        if (inputElement instanceof TargetDevice[]) {
            return (TargetDevice[])inputElement;
        }
        if (inputElement instanceof EList) {
            return (TargetDevice[])((EList)inputElement).toArray();
        }
        if (inputElement instanceof TargetDevice) {
            TargetDevice target = (TargetDevice)inputElement;
            elements = new Object[]{target.getRuntimePlatform()};
        } else if (inputElement instanceof RuntimePlatformDefinition) {
            RuntimePlatformDefinition rpd = (RuntimePlatformDefinition)inputElement;
            elements = new Object[]{rpd.getDeviceProfiles().get(0), rpd.getDeviceConfigurations().get(0), (ServiceApi[])rpd.getServiceApis().toArray()};
        } else if (inputElement instanceof DeviceConfiguration) {
            DeviceConfiguration config = (DeviceConfiguration)inputElement;
            elements = new Object[]{config.getImplementation()};
        } else if (inputElement instanceof DeviceProfile) {
            DeviceProfile profile = (DeviceProfile)inputElement;
            elements = new Object[]{(ServiceApi[])profile.getServiceApis().toArray()};
        } else if (inputElement instanceof ServiceApi) {
            ServiceApi sapi = (ServiceApi)inputElement;
            elements = new Object[]{sapi.getDescription(), sapi.getImplementation()};
        } else {
            if (inputElement instanceof ServiceApi[]) {
                return (ServiceApi[])inputElement;
            }
            if (inputElement instanceof ImplementationRef) {
                ImplementationRef ref = (ImplementationRef)inputElement;
                elements = new Object[]{ref.getFileRef(), ref.getSourceRef(), ref.getJavadocRef()};
            } else {
                elements = new Object[]{inputElement};
            }
        }
        return elements;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
        this.myInput = newInput;
    }

    public Object addVariable(Object inputElement, TargetDevice[] devices) {
        if (inputElement instanceof TargetDevice[]) {
            TargetDevice[] oldInput = (TargetDevice[])inputElement;
            TargetDevice[] newRpInput = new TargetDevice[oldInput.length + devices.length];
            int i = 0;
            while (i < oldInput.length) {
                newRpInput[i] = oldInput[i];
                ++i;
            }
            i = 0;
            while (i < devices.length) {
                newRpInput[oldInput.length + i] = devices[i];
                ++i;
            }
            this.myInput = newRpInput;
        } else if (inputElement instanceof EList) {
            EList list = (EList)inputElement;
            int i = 0;
            while (i < devices.length) {
                list.add((Object)devices[i]);
                ++i;
            }
            Object[] newTargets = new TargetDevice[list.size()];
            this.myInput = (TargetDevice[])list.toArray(newTargets);
        } else if (inputElement == null) {
            this.myInput = devices;
        }
        this.myViewer.setInput(this.myInput);
        return this.myInput;
    }

    public TargetDevice[] removeVariable(Object oldInputElement, TargetDevice selectedDevice) {
        if (oldInputElement instanceof TargetDevice[]) {
            TargetDevice[] oldInput = (TargetDevice[])oldInputElement;
            if (oldInput.length == 1) {
                return null;
            }
            ArrayList<TargetDevice> list = new ArrayList<TargetDevice>();
            int i = 0;
            while (i < oldInput.length) {
                if (!oldInput[i].equals(selectedDevice)) {
                    list.add(oldInput[i]);
                }
                ++i;
            }
            TargetDevice[] newInput = new TargetDevice[list.size()];
            return list.toArray(newInput);
        }
        if (oldInputElement instanceof EList) {
            EList list = (EList)oldInputElement;
            if (list.size() == 1) {
                return null;
            }
            list.remove((Object)selectedDevice);
            return (TargetDevice[])list.toArray();
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        Vector<Object> l = new Vector<Object>();
        if (parentElement instanceof TargetDevice[]) {
            TargetDevice[] targets = (TargetDevice[])parentElement;
            int i = 0;
            while (i < targets.length) {
                l.add(targets[i]);
                ++i;
            }
        } else if (parentElement instanceof TargetDevice) {
            TargetDevice target = (TargetDevice)parentElement;
            l.add(target.getRuntimePlatform());
        } else if (parentElement instanceof RuntimePlatformDefinition) {
            RuntimePlatformDefinition rpd = (RuntimePlatformDefinition)parentElement;
            l.addAll((Collection<Object>)rpd.getDeviceConfigurations());
            l.addAll((Collection<Object>)rpd.getDeviceProfiles());
            l.addAll((Collection<Object>)rpd.getServiceApis());
        } else if (parentElement instanceof DeviceConfiguration) {
            DeviceConfiguration config = (DeviceConfiguration)parentElement;
            l.add(config.getImplementation());
        } else if (parentElement instanceof DeviceProfile) {
            DeviceProfile profile = (DeviceProfile)parentElement;
            l.addAll((Collection<Object>)profile.getServiceApis());
        } else if (parentElement instanceof ServiceApi) {
            ServiceApi sapi = (ServiceApi)parentElement;
            l.add(sapi.getDescription());
            l.add(sapi.getImplementation());
        } else if (parentElement instanceof ImplementationRef) {
            ImplementationRef ref = (ImplementationRef)parentElement;
            l.add(ref.getSourceRef());
            l.add(ref.getJavadocRef());
        }
        return l.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object parentElement) {
        if (parentElement instanceof TargetDevice[]) {
            return true;
        }
        if (parentElement instanceof TargetDevice) {
            return true;
        }
        if (parentElement instanceof RuntimePlatformDefinition) {
            return true;
        }
        if (parentElement instanceof DeviceConfiguration) {
            return true;
        }
        if (parentElement instanceof DeviceProfile) {
            return true;
        }
        if (parentElement instanceof ServiceApi) {
            return true;
        }
        if (parentElement instanceof ImplementationRef) {
            ImplementationRef ref = (ImplementationRef)parentElement;
            String javadoc = ref.getJavadocRef();
            String source = ref.getSourceRef();
            if (javadoc != null && source != null) {
                return javadoc.length() > 1 || source.length() > 1;
            }
            return false;
        }
        return false;
    }
}

