/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.executable;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.MidletDeployment;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.executable.ClasspathCollectionVisitor;

public abstract class AbstractExecutable {
    protected void addDebugArguments(ArrayList arguments, int port, boolean debugServer) throws CoreException {
        this.addXDebugArgument(arguments);
        this.addXRunjdwpArgument(arguments, port, debugServer);
    }

    protected void addXDebugArgument(ArrayList arguments) throws CoreException {
        arguments.add("-Xdebug");
    }

    protected void addXNoagentArgument(ArrayList arguments) throws CoreException {
        arguments.add("-Xnoagent");
    }

    protected void addXRunjdwpArgument(ArrayList arguments, int port, boolean debugServer) throws CoreException {
        try {
            InetAddress address = InetAddress.getLocalHost();
            address.getHostName();
        }
        catch (UnknownHostException e) {
            MtjCorePlugin.throwCoreException((int)2, (int)-999, (Throwable)e);
        }
        StringBuffer argument = new StringBuffer("-Xrunjdwp:transport=dt_socket,suspend=y,server=");
        argument.append(debugServer ? "y" : "n");
        argument.append(",address=");
        argument.append(port);
        arguments.add(argument.toString());
    }

    protected void addClasspath(ArrayList arguments, ILaunchConfiguration configuration, String natureId, IProgressMonitor monitor) throws CoreException {
        arguments.add("-classpath");
        this.addDeploymentClasspath(arguments, configuration, natureId, monitor);
    }

    private void addDeploymentClasspath(ArrayList progArgs, ILaunchConfiguration configuration, String natureId, IProgressMonitor monitor) throws CoreException {
        progArgs.add(this.getQuotedString(this.getClasspathString(configuration, natureId, monitor)));
    }

    protected String getQuotedString(String string) {
        StringBuffer sb = new StringBuffer("\"");
        sb.append(string);
        sb.append("\"");
        return sb.toString();
    }

    protected String getClasspathString(ILaunchConfiguration launchConfig, String natureId, IProgressMonitor monitor) throws CoreException {
        Set cpEntries = this.getClasspathEntries(launchConfig, natureId, monitor);
        StringBuffer cp = new StringBuffer();
        Iterator iter = cpEntries.iterator();
        while (iter.hasNext()) {
            IPath path = (IPath)iter.next();
            cp.append(path.toOSString());
            if (!iter.hasNext()) continue;
            cp.append(File.pathSeparatorChar);
        }
        return cp.toString();
    }

    private Set getClasspathEntries(ILaunchConfiguration launchConfig, String natureId, IProgressMonitor monitor) throws CoreException, JavaModelException {
        IJavaProject javaProject = this.getJavaProject(launchConfig);
        IMtjProject suite = this.getMtjProject(launchConfig);
        IPath classesPath = suite.getVerifiedClassesOutputFolder(monitor).getLocation();
        IPath libsPath = suite.getVerifiedLibrariesOutputFolder(monitor).getLocation();
        ClasspathCollectionVisitor visitor = new ClasspathCollectionVisitor(classesPath, libsPath);
        visitor.getRunner().run(javaProject, visitor, natureId, monitor);
        Set cpEntries = visitor.getCpEntries();
        return cpEntries;
    }

    protected abstract IMtjProject getMtjProject(IJavaProject var1) throws MtjException;

    protected IMtjProject getMtjProject(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        try {
            return this.getMtjProject(javaProject);
        }
        catch (MtjException e) {
            Status status = new Status(4, "org.eclipse.mtj.core.ui", 2562, MtjCoreErrors.getErrorMessage((int)2562), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    protected IJavaProject getJavaProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IJavaProject javaProject;
        String projectName = this.getJavaProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (javaProject = JavaCore.create((IProject)(project = MtjCorePlugin.getWorkspace().getRoot().getProject(projectName)))) != null && javaProject.exists()) {
            return javaProject;
        }
        return null;
    }

    private String getJavaProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
    }

    protected void addLaunchConfigurationArgument(ArrayList progArgs, ILaunchConfiguration configuration, String configKey, String commandString, boolean keyValueSpace) throws CoreException {
        String configValue = configuration.getAttribute(configKey, null);
        if (configValue != null) {
            if (keyValueSpace) {
                progArgs.add(commandString);
                progArgs.add(configValue);
            } else {
                progArgs.add(String.valueOf(commandString) + configValue);
            }
        }
    }

    protected void addLaunchConfigurationArgument(ArrayList progArgs, ILaunchConfiguration configuration, Device device, String commandString, boolean keyValueSpace) throws CoreException {
        String configValue = device.getName();
        if (configValue != null) {
            if (keyValueSpace) {
                progArgs.add(commandString);
                progArgs.add(configValue);
            } else {
                progArgs.add(String.valueOf(commandString) + configValue);
            }
        }
    }

    protected void addDescriptorArgument(ArrayList arguments, Deployment deployment, ILaunchConfiguration configuration, Device device) throws CoreException {
        if (deployment instanceof MidletDeployment) {
            this.addDescriptorArgument(arguments, (MidletDeployment)deployment, configuration, device);
        }
    }

    protected void addDescriptorArgument(ArrayList arguments, MidletDeployment deployment, ILaunchConfiguration configuration, Device device) throws CoreException {
        File jadFile;
        if (!this.shouldDoOTA(configuration, device) && (jadFile = deployment.getJad()) != null) {
            arguments.add(this.getQuotedString("-Xdescriptor:" + jadFile.getAbsolutePath()));
        }
    }

    protected boolean shouldDoOTA(ILaunchConfiguration configuration, Device device) throws CoreException {
        if (device != null) {
            return device.getCommunicationProtocol().getValue() == 2;
        }
        return false;
    }

    protected void addMiscellaneousArguments(ArrayList arguments, ILaunchConfiguration configuration, Device device) throws CoreException {
        this.addLaunchConfigurationArgument(arguments, configuration, "org.eclipse.mtj.verbosity_options", "-Xverbose:", false);
        this.addLaunchConfigurationArgument(arguments, configuration, "org.eclipse.mtj.heap_size", "-Xheapsize:", false);
    }

    protected void addSecurityDomain(ArrayList progArgs, ILaunchConfiguration configuration) throws CoreException {
        String domainName = configuration.getAttribute("org.eclipse.mtj.security_domain", "None");
        if (!domainName.equals("None")) {
            progArgs.add("-Xdomain:" + domainName);
        }
    }

    protected void addExtraLaunchArguments(ArrayList arguments, ILaunchConfiguration configuration) throws CoreException {
        String extraArguments = configuration.getAttribute("org.eclipse.mtj.launch_params", "");
        StringTokenizer st = new StringTokenizer(extraArguments);
        while (st.hasMoreTokens()) {
            arguments.add(st.nextToken());
        }
    }

    protected void addEmulationTarget(ArrayList arguments, ILaunchConfiguration configuration, Deployment deployment, Device device) throws CoreException {
        if (this.shouldDoOTA(configuration, device)) {
            this.addOverTheAirParameter(arguments, configuration, deployment);
        } else {
            this.addLaunchConfigurationArgument(arguments, configuration, "org.eclipse.mtj.executable_class", " ", false);
        }
    }

    private void addOverTheAirParameter(ArrayList args, ILaunchConfiguration configuration, Deployment deployment) throws CoreException {
        String url = this.getOTAURL(configuration, deployment);
        if (url != null) {
            String param = "-Xjam:transient=" + this.getOTAURL(configuration, deployment);
            args.add(param);
        }
    }

    protected String getOTAURL(ILaunchConfiguration launchConfig, Deployment deployment) throws CoreException {
        if (deployment instanceof MidletDeployment) {
            return this.getOTAURL(launchConfig, (Deployment)((MidletDeployment)deployment));
        }
        return null;
    }

    protected String urlEncoded(String value) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return encoded;
    }

    protected void addKeepAlivePort(ArrayList arguments, ILaunchConfiguration configuration) throws CoreException {
        arguments.add("0");
    }

    protected String convertArgsToString(ArrayList args) {
        StringBuffer sb = new StringBuffer();
        Iterator argsIter = args.iterator();
        while (argsIter.hasNext()) {
            String argument = (String)argsIter.next();
            sb.append(argument);
            if (!argsIter.hasNext()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    protected void addDescriptorArgument(ArrayList arguments, ILaunchConfiguration configuration, Deployment deployment) throws CoreException {
        if (deployment instanceof MidletDeployment) {
            this.addDescriptorArgument(arguments, configuration, (Deployment)((MidletDeployment)deployment));
        }
    }

    protected void addDescriptorArgument(ArrayList arguments, ILaunchConfiguration configuration, MidletDeployment deployment, Device device) throws CoreException {
        File jadFile;
        if (!this.shouldDoOTA(configuration, device) && (jadFile = deployment.getJad()).exists()) {
            arguments.add(this.getQuotedString("-Xdescriptor:" + jadFile.getAbsolutePath()));
        }
    }
}

