/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.launching;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.ProtectionDomain;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.launching.JavaTab;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DeviceTab
extends AbstractLaunchConfigurationTab {
    private Label deviceLabel;
    private Text extraParameters;
    private Button projectDefButton;
    private Combo platformDevicesCombo;
    private Button specificDefButton;
    private Combo securityDomainCombo;
    private JavaTab javaTab;

    public DeviceTab(JavaTab javaTab) {
        this.javaTab = javaTab;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        Group group = new Group(comp, 32);
        group.setText(Messages.launchtab_device_target_device_label);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.projectDefButton = new Button((Composite)group, 16);
        this.projectDefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceTab.this.platformDevicesCombo.setEnabled(false);
                DeviceTab.this.updateSecurityDomains();
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label projectDefLabel = new Label((Composite)group, 0);
        projectDefLabel.setText(Messages.launchtab_device_project_default_device_label);
        this.specificDefButton = new Button((Composite)group, 16);
        this.specificDefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceTab.this.platformDevicesCombo.setEnabled(true);
                DeviceTab.this.updateTagrgetDevices();
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.platformDevicesCombo = new Combo((Composite)group, 12);
        this.platformDevicesCombo.setFont(font);
        this.platformDevicesCombo.setEnabled(false);
        this.platformDevicesCombo.setLayoutData((Object)new GridData(768));
        this.platformDevicesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceTab.this.updateSecurityDomains();
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label securityDomainLabel = new Label(comp, 0);
        securityDomainLabel.setText("Security Domain:");
        securityDomainLabel.setFont(font);
        this.securityDomainCombo = new Combo(comp, 12);
        this.securityDomainCombo.setFont(font);
        this.securityDomainCombo.setLayoutData((Object)new GridData(768));
        this.securityDomainCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public Image getImage() {
        ImageDescriptor descriptor = MtjCoreUiPlugin.getIconImage((String)"cellphone_icon.gif");
        return descriptor.createImage();
    }

    public String getName() {
        return Messages.launchtab_device_target_device_label;
    }

    public void initializeFrom(ILaunchConfiguration launchConfig) {
        this.initializePlatformDefinitionFrom(launchConfig);
        try {
            this.initializeDevicesFrom(launchConfig);
        }
        catch (MtjException e) {
            this.showError("Error while initializing Project's target devices", (Exception)((Object)e));
        }
        this.updateSecurityDomains();
        String domain = this.getStringOrDefault(launchConfig, "org.eclipse.mtj.security_domain", "None");
        this.securityDomainCombo.setText(domain);
        this.updateLaunchConfigurationDialog();
    }

    private void initializeDevicesFrom(ILaunchConfiguration launchConfig) throws MtjException {
        if (this.specificDefButton.getSelection()) {
            this.platformDevicesCombo.setEnabled(true);
            this.updateTagrgetDevices();
            String deviceName = this.getStringOrDefault(launchConfig, "org.eclipse.mtj.emulated_device_name", "");
            this.platformDevicesCombo.select(this.platformDevicesCombo.indexOf(deviceName));
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        TargetDevice targetDevice = this.getSelectedTargetDevice();
        if (targetDevice == null) {
            this.setErrorMessage(Messages.launchtab_device_error_Target_device_not_selected);
            return false;
        }
        return true;
    }

    private IJavaProject getJavaProject() {
        return this.javaTab.getJavaProject();
    }

    private void updateTagrgetDevices() {
        this.platformDevicesCombo.removeAll();
        try {
            IMtjProject project = MtjProject.getMtjProject(this.getJavaProject());
            if (project != null) {
                TargetDevice defaultdevice = project.getProjectData().getDefaultTargetDevice();
                if (defaultdevice != null) {
                    this.platformDevicesCombo.add(defaultdevice.getName() != null ? defaultdevice.getName() : defaultdevice.getDeviceName() + " - " + defaultdevice.getDevicePlatformName());
                }
                for (TargetDevice device : project.getProjectData().getTargetDevices()) {
                    this.platformDevicesCombo.add(device.getName() != null ? device.getName() : device.getDeviceName() + " - " + device.getDevicePlatformName());
                }
            }
        }
        catch (MtjException ex) {
            this.showError(Messages.DeviceTab_8, (Exception)((Object)ex));
        }
    }

    private void initializePlatformDefinitionFrom(ILaunchConfiguration launchConfig) {
        boolean useProjectPlatform = true;
        try {
            useProjectPlatform = launchConfig.getAttribute("org.eclipse.mtj.use_project_platform_def", true);
        }
        catch (CoreException e) {
            MtjCorePlugin.log((int)2, (String)Messages.DeviceTab_9, (Throwable)e);
        }
        this.projectDefButton.setSelection(useProjectPlatform);
        this.specificDefButton.setSelection(!useProjectPlatform);
    }

    public void performApply(ILaunchConfigurationWorkingCopy launchConfig) {
        launchConfig.setAttribute("org.eclipse.mtj.use_project_platform_def", this.projectDefButton.getSelection());
        TargetDevice device = this.getSelectedTargetDevice();
        if (device != null) {
            launchConfig.setAttribute("org.eclipse.mtj.emulation_platform_def", device.getDevicePlatformName());
            launchConfig.setAttribute("org.eclipse.mtj.emulated_device", device.getDeviceName());
            launchConfig.setAttribute("org.eclipse.mtj.emulated_device_name", device.getName() != null ? device.getName() : device.getDeviceName() + " - " + device.getDevicePlatformName());
        }
        launchConfig.setAttribute("org.eclipse.mtj.security_domain", this.securityDomainCombo.getText());
    }

    private TargetDevice getSelectedTargetDevice() {
        if (this.projectDefButton.getSelection()) {
            TargetDevice device = null;
            try {
                IMtjProject project = MtjProject.getMtjProject(this.getJavaProject());
                if (project != null) {
                    device = project.getProjectData().getDefaultTargetDevice();
                }
            }
            catch (MtjException ex) {
                this.showError(Messages.DeviceTab_12, (Exception)((Object)ex));
            }
            return device;
        }
        if (this.platformDevicesCombo.getItemCount() > 0 && this.platformDevicesCombo.getSelectionIndex() != -1) {
            String deviceName = this.platformDevicesCombo.getItem(this.platformDevicesCombo.getSelectionIndex());
            String devPlatName = "";
            String devName = "";
            if (deviceName != null && deviceName.indexOf(" - ") != -1) {
                devPlatName = deviceName.substring(deviceName.indexOf(" - ") + 3);
                devName = deviceName.substring(0, deviceName.indexOf(" - "));
            }
            Iterator it = null;
            try {
                IMtjProject project = MtjProject.getMtjProject(this.getJavaProject());
                TargetDevice defaultdevice = project.getProjectData().getDefaultTargetDevice();
                if (defaultdevice != null && (defaultdevice.getName() != null && deviceName.equals(defaultdevice.getName()) || defaultdevice.getName() == null && devPlatName.equals(defaultdevice.getDevicePlatformName()) && devName.equals(defaultdevice.getDeviceName()))) {
                    return defaultdevice;
                }
                it = project.getProjectData().getTargetDevices().iterator();
            }
            catch (MtjException ex) {
                this.showError(Messages.DeviceTab_20, (Exception)((Object)ex));
            }
            while (it.hasNext()) {
                TargetDevice device = (TargetDevice)it.next();
                if (device == null || (device.getName() == null || !deviceName.equals(device.getName())) && (device.getName() != null || !devPlatName.equals(device.getDevicePlatformName()) || !devName.equals(device.getDeviceName()))) continue;
                return device;
            }
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy launchConfig) {
        launchConfig.setAttribute("org.eclipse.mtj.use_project_platform_def", true);
        TargetDevice device = null;
        try {
            IJavaProject javaProject = this.getJavaProject();
            if (javaProject != null) {
                IMtjProject project = MtjProject.getMtjProject(javaProject);
                device = project.getProjectData().getDefaultTargetDevice();
            }
        }
        catch (MtjException ex) {
            this.showError(Messages.DeviceTab_21, (Exception)((Object)ex));
        }
        if (device != null) {
            launchConfig.setAttribute("org.eclipse.mtj.emulation_platform_def", device.getDevicePlatformName());
            launchConfig.setAttribute("org.eclipse.mtj.emulated_device", device.getDeviceName());
        }
        launchConfig.setAttribute("org.eclipse.mtj.security_domain", "None");
        launchConfig.setAttribute("org.eclipse.mtj.launch_params", "");
    }

    public void setJavaProject(IJavaProject project) {
        if (project != null && this.specificDefButton.getSelection()) {
            this.updateTagrgetDevices();
            this.updateSecurityDomains();
            this.updateLaunchConfigurationDialog();
        }
    }

    private String getStringOrDefault(ILaunchConfiguration launchConfig, String attributeName, String defaultValue) {
        String value = null;
        try {
            value = launchConfig.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            MtjCorePlugin.log((int)2, (Throwable)e);
            value = defaultValue;
        }
        return value;
    }

    private void updateSecurityDomains() {
        boolean enabled = false;
        this.securityDomainCombo.removeAll();
        TargetDevice targetdevice = this.getSelectedTargetDevice();
        if (targetdevice != null) {
            Device device = null;
            try {
                IMtjProject project = MtjProject.getMtjProject(this.getJavaProject());
                device = project.getDevice(targetdevice);
            }
            catch (MtjException ex) {
                this.showError(Messages.DeviceTab_23, (Exception)((Object)ex));
            }
            if (device != null) {
                ArrayList list = new ArrayList();
                Iterator it = device.getProtectionDomains().iterator();
                while (it.hasNext()) {
                    list.add(it.next());
                }
                String[] securityDomains = new String[list.size() + 1];
                securityDomains[0] = "None";
                int i = 1;
                it = list.iterator();
                while (it.hasNext()) {
                    securityDomains[i] = ((ProtectionDomain)it.next()).getName();
                    ++i;
                }
                if (list.size() > 0) {
                    enabled = true;
                }
                this.securityDomainCombo.setItems(securityDomains);
                this.securityDomainCombo.setText("None");
            }
        }
        this.securityDomainCombo.setEnabled(enabled);
    }

    private void showError(String definition, Exception ex) {
        Status status = new Status(4, "org.eclipse.mtj.core.ui", -1, ex != null ? ex.toString() : "", (Throwable)ex);
        ErrorDialog.openError((Shell)MtjCoreUiPlugin.getActiveWindowShell(), (String)Messages.DeviceTab_25, (String)definition, (IStatus)status);
    }
}

