/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.properties;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.devide.properties.RuntimeListComposite;
import org.eclipse.mtj.extension.devide.properties.RuntimeListController;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class RuntimePlatformPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static Logger log = Logger.getLogger(RuntimePlatformPage.class.getName());
    private IMtjProject myProject;
    private Project myProjectData;
    private RuntimeListController controller;

    public RuntimePlatformPage() {
        log.info(Messages.RuntimePlatformPage_Constructing_devide_property_page);
        this.setTitle(Messages.RuntimePlatformPage_Project_Runtime_Platform_title);
        this.setDescription(Messages.RuntimePlatformPage_Select_and_edit_runtime_platform);
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        this.initData();
        RuntimeListComposite rlc = new RuntimeListComposite(parent);
        this.controller = new RuntimeListController(rlc, this.myProject, this.myProjectData);
        return rlc;
    }

    private void initData() {
        IJavaProject javaProject = ((IJavaProject)this.getElement()).getJavaProject();
        try {
            this.myProject = MtjProject.getMtjProject(javaProject);
            this.myProjectData = this.myProject.getProjectData();
        }
        catch (Exception e) {
            log.log(Level.WARNING, Messages.RuntimePlatformPage_Can_not_find_project, e);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        try {
            this.myProjectData.setDefaultTargetDevice(this.controller.getDefaultTargetDevice());
            this.myProject.setProjectData(this.myProjectData);
        }
        catch (Exception e) {
            log.log(Level.WARNING, Messages.RuntimePlatformPage_Can_not_save_project_data, e);
            return false;
        }
        return true;
    }
}

