/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.executable.uei;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimesFactory;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.library.MtjCoreLibraryPlugin;
import org.eclipse.mtj.core.library.config.LibrarySpecification;
import org.eclipse.mtj.executable.uei.AbstractServiceApiImporter;
import org.eclipse.mtj.executable.uei.IServiceApiImporter;
import org.eclipse.mtj.executable.uei.Messages;

public class ServiceApiImporter
extends AbstractServiceApiImporter {
    private static IServiceApiImporter instance;

    public static IServiceApiImporter getInstance() {
        if (instance == null) {
            instance = new ServiceApiImporter();
        }
        return instance;
    }

    private ServiceApiImporter() {
    }

    public ServiceApi[] getServiceApis(File libraryFile) {
        ArrayList apis = new ArrayList();
        try {
            List lib = MtjCoreLibraryPlugin.getCorrLibrarySpecifications((File)libraryFile);
            int i = 0;
            while (i < lib.size()) {
                this.addOptional((LibrarySpecification)lib.get(i), apis, libraryFile);
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return apis.toArray(new ServiceApi[apis.size()]);
    }

    private void addConfiguration(LibrarySpecification[] libs, ArrayList apis, File libraryFile) {
        int i = 0;
        while (i < libs.length) {
            DeviceConfiguration api = RuntimesFactory.eINSTANCE.createDeviceConfiguration();
            apis.add(api);
            ImplementationRef implRef = RuntimesFactory.eINSTANCE.createImplementationRef();
            implRef.setFileRef(libraryFile.getAbsolutePath());
            api.setImplementation(implRef);
            api.setName(libs[i].getName());
            api.setVersion(libs[i].getVersion().toString());
            ++i;
        }
    }

    private void addOptional(LibrarySpecification lib, ArrayList apis, File libraryFile) {
        ServiceApi api = RuntimesFactory.eINSTANCE.createServiceApi();
        apis.add(api);
        if (lib != null) {
            api.setName(lib.getName());
            api.setDescription(lib.getLabel());
            api.setVersion(lib.getVersion().toString());
        } else {
            api.setName(libraryFile.getName());
            api.setDescription(Messages.ServiceApiImporter_EmulatorSpecificLibrary);
            api.setVersion("");
        }
        ImplementationRef implRef = RuntimesFactory.eINSTANCE.createImplementationRef();
        implRef.setFileRef(libraryFile.getAbsolutePath());
        api.setImplementation(implRef);
    }

    private void addProfile(LibrarySpecification[] libs, ArrayList apis, File libraryFile) {
        int i = 0;
        while (i < libs.length) {
            DeviceProfile api = RuntimesFactory.eINSTANCE.createDeviceProfile();
            apis.add(api);
            api.setName(libs[i].getName());
            api.setVersion(libs[i].getVersion().toString());
            ++i;
        }
    }

    private boolean zipContainsEntry(ZipFile zipFile, String entryName) {
        return zipFile.getEntry(entryName) != null;
    }

    public DeviceProfile[] getProfileApis(File libraryFile) {
        ArrayList apis = new ArrayList();
        try {
            LibrarySpecification[] libs = MtjCoreLibraryPlugin.getLibrarySpecifications((File)libraryFile, (String)"profile");
            if (libs != null && libs.length > 0) {
                this.addProfile(libs, apis, libraryFile);
            }
        }
        catch (CoreException coreException) {}
        return apis.toArray(new DeviceProfile[apis.size()]);
    }

    public DeviceConfiguration[] getConfigurationApis(File libraryFile) {
        ArrayList apis = new ArrayList();
        try {
            LibrarySpecification[] libs = MtjCoreLibraryPlugin.getLibrarySpecifications((File)libraryFile, (String)"configuration");
            if (libs != null && libs.length > 0) {
                this.addConfiguration(libs, apis, libraryFile);
            }
        }
        catch (CoreException coreException) {}
        return apis.toArray(new DeviceConfiguration[apis.size()]);
    }
}

