/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.executable.uei;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimesFactory;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.executable.uei.AbstractServiceApiImporter;
import org.eclipse.mtj.executable.uei.IServiceApiImporter;

public class ServiceApiManifestImporter
extends AbstractServiceApiImporter {
    private static final String VERSION = "API-Specification-Version";
    private static final String IDENTIFIER = "API";
    private static final String NAME = "API-Name";
    private static final String TYPE = "API-Type";
    private static final String TYPE_PROFILE = "Profile";
    private static final String TYPE_CONFIGURATION = "Configuration";
    private static final String TYPE_OPTIONAL = "Optional";
    private static final int API_UNKNOWN = 0;
    private static final int API_OPTIONAL = 1;
    private static final int API_PROFILE = 2;
    private static final int API_CONFIGURATION = 3;
    private static IServiceApiImporter instance;

    public static IServiceApiImporter getInstance() {
        if (instance == null) {
            instance = new ServiceApiManifestImporter();
        }
        return instance;
    }

    private ServiceApiManifestImporter() {
    }

    public ServiceApi[] getServiceApis(File libraryFile) {
        ServiceApi[] serviceApiArray;
        String identifier;
        ServiceApi api = null;
        Attributes attributes = this.getAttributes(libraryFile);
        if (attributes != null && this.getType(attributes) == 1 && (identifier = attributes.getValue(IDENTIFIER)) != null) {
            api = RuntimesFactory.eINSTANCE.createServiceApi();
            api.setName(identifier);
            api.setDescription(attributes.getValue(NAME));
            api.setVersion(this.getVersion(attributes));
            ImplementationRef implRef = RuntimesFactory.eINSTANCE.createImplementationRef();
            implRef.setFileRef(libraryFile.getAbsolutePath());
            api.setImplementation(implRef);
        }
        if (api == null) {
            serviceApiArray = null;
        } else {
            ServiceApi[] serviceApiArray2 = new ServiceApi[1];
            serviceApiArray = serviceApiArray2;
            serviceApiArray2[0] = api;
        }
        return serviceApiArray;
    }

    private Attributes getAttributes(File libraryFile) {
        Attributes attributes = null;
        try {
            Manifest manifest;
            JarFile jarFile = new JarFile(libraryFile);
            if (jarFile != null && (manifest = jarFile.getManifest()) != null) {
                attributes = manifest.getMainAttributes();
            }
        }
        catch (IOException iOException) {}
        return attributes;
    }

    public DeviceConfiguration[] getConfigurationApis(File libraryFile) {
        DeviceConfiguration[] deviceConfigurationArray;
        String identifier;
        DeviceConfiguration api = null;
        Attributes attributes = this.getAttributes(libraryFile);
        if (attributes != null && this.getType(attributes) == 3 && (identifier = attributes.getValue(IDENTIFIER)) != null) {
            api = RuntimesFactory.eINSTANCE.createDeviceConfiguration();
            api.setName(identifier);
            api.setVersion(this.getVersion(attributes));
            ImplementationRef implRef = RuntimesFactory.eINSTANCE.createImplementationRef();
            implRef.setFileRef(libraryFile.getAbsolutePath());
            api.setImplementation(implRef);
        }
        if (api == null) {
            deviceConfigurationArray = null;
        } else {
            DeviceConfiguration[] deviceConfigurationArray2 = new DeviceConfiguration[1];
            deviceConfigurationArray = deviceConfigurationArray2;
            deviceConfigurationArray2[0] = api;
        }
        return deviceConfigurationArray;
    }

    public DeviceProfile[] getProfileApis(File libraryFile) {
        DeviceProfile[] deviceProfileArray;
        String identifier;
        DeviceProfile api = null;
        Attributes attributes = this.getAttributes(libraryFile);
        if (attributes != null && this.getType(attributes) == 2 && (identifier = attributes.getValue(IDENTIFIER)) != null) {
            api = RuntimesFactory.eINSTANCE.createDeviceProfile();
            api.setName(identifier);
            api.setVersion(this.getVersion(attributes));
        }
        if (api == null) {
            deviceProfileArray = null;
        } else {
            DeviceProfile[] deviceProfileArray2 = new DeviceProfile[1];
            deviceProfileArray = deviceProfileArray2;
            deviceProfileArray2[0] = api;
        }
        return deviceProfileArray;
    }

    private int getType(Attributes attributes) {
        int type = 0;
        String typeString = attributes.getValue(TYPE);
        if (typeString == null) {
            return type;
        }
        if (typeString.equalsIgnoreCase(TYPE_OPTIONAL)) {
            type = 1;
        } else if (typeString.equalsIgnoreCase(TYPE_PROFILE)) {
            type = 2;
        } else if (typeString.equalsIgnoreCase(TYPE_CONFIGURATION)) {
            type = 3;
        }
        return type;
    }

    private String getVersion(Attributes attributes) {
        String versionString = attributes.getValue(VERSION);
        if (versionString == null) {
            versionString = "0.0.0";
        }
        return versionString;
    }
}

