/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.rpm.preferences;

import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.RuntimePlatform;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.extension.rpm.Messages;
import org.eclipse.mtj.extension.rpm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.rpm.model.RpmUIManager;
import org.eclipse.mtj.extension.rpm.preferences.RuntimePlatformContentProvider;
import org.eclipse.mtj.extension.rpm.preferences.RuntimePlatformLabelProvider;
import org.eclipse.mtj.extension.rpm.preferences.RuntimePlatformSorter;
import org.eclipse.mtj.extension.rpm.ui.preferences.RuntimeListComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class RpmController
implements SelectionListener,
ISelectionChangedListener,
ICheckStateListener {
    private static Logger log = Logger.getLogger(RpmController.class.getName());
    private RuntimeListComposite runtimeListComposite;
    private MtjServiceHandler mtjServiceHandler = new MtjServiceHandler();
    private RuntimePlatform selectedRuntime;
    private Shell containerShell = new Shell();
    private Button addButton;
    private Button editRuntimeButton;
    private Button editDeviceButton;
    private Button removeButton;
    private TableViewer runtimeTableViewer;
    private CheckboxTableViewer deviceTableViewer;

    public RpmController(RuntimeListComposite runtimeListComposite) {
        this.runtimeListComposite = runtimeListComposite;
        this.addButton = runtimeListComposite.getAddButton();
        this.editRuntimeButton = runtimeListComposite.getEditRuntimeButton();
        this.editDeviceButton = runtimeListComposite.getEditDeviceButton();
        this.removeButton = runtimeListComposite.getRemoveButton();
        this.runtimeTableViewer = runtimeListComposite.getRuntimeTableViewer();
        this.deviceTableViewer = runtimeListComposite.getDeviceTableViewer();
        this.setData();
        this.addListener();
    }

    private static TableColumn createTableColumn(String title, Table table, int index, int widthHint) {
        TableColumn tableColumn = new TableColumn(table, 0, index);
        tableColumn.setResizable(true);
        tableColumn.setWidth(widthHint);
        tableColumn.setText(title);
        return tableColumn;
    }

    private void setData() {
        this.runtimeTableViewer.setContentProvider((IContentProvider)new RuntimePlatformContentProvider(this.runtimeTableViewer));
        this.runtimeTableViewer.setSorter((ViewerSorter)new RuntimePlatformSorter(1));
        this.runtimeTableViewer.setLabelProvider((IBaseLabelProvider)new RuntimePlatformLabelProvider());
        RpmController.createTableColumn(Messages.RpmController_RuntimeTableViewerName, this.runtimeTableViewer.getTable(), 0, 100);
        RpmController.createTableColumn(Messages.RpmController_RuntimeTableViewerDescription, this.runtimeTableViewer.getTable(), 1, 200);
        private class EListContentProvider
        implements IStructuredContentProvider {
            EListContentProvider() {
            }

            public Object[] getElements(Object o) {
                if (o instanceof EList) {
                    return ((EList)o).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
        this.deviceTableViewer.setContentProvider((IContentProvider)new EListContentProvider());
        private class Tlp
        extends LabelProvider
        implements ITableLabelProvider {
            Tlp() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof Device) {
                    Device device = (Device)element;
                    if (columnIndex == 0) {
                        return "";
                    }
                    if (columnIndex == 1) {
                        return device.getName();
                    }
                    if (columnIndex == 2) {
                        return device.getDescription();
                    }
                }
                return null;
            }
        }
        this.deviceTableViewer.setLabelProvider((IBaseLabelProvider)new Tlp());
        RpmController.createTableColumn("", this.deviceTableViewer.getTable(), 0, 20);
        RpmController.createTableColumn(Messages.RpmController_DeviceTableViewerName, this.deviceTableViewer.getTable(), 1, 160);
        RpmController.createTableColumn(Messages.RpmController_DeviceTableViewerDescription, this.deviceTableViewer.getTable(), 2, 160);
        this.runtimeTableViewer.setInput((Object)this.mtjServiceHandler.getRuntimePlatforms());
        this.editRuntimeButton.setEnabled(false);
        this.editDeviceButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void addListener() {
        this.addButton.addSelectionListener((SelectionListener)this);
        this.editRuntimeButton.addSelectionListener((SelectionListener)this);
        this.editDeviceButton.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.runtimeTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.deviceTableViewer.addCheckStateListener((ICheckStateListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addButton) {
            this.addRuntimePlatform();
        } else if (e.widget == this.editRuntimeButton) {
            this.editRuntimePlatform(this.selectedRuntime);
        } else if (e.widget == this.editDeviceButton) {
            this.editDevicePlatform(this.selectedRuntime);
        } else if (e.widget == this.removeButton) {
            this.removeRuntimePlatform();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = this.runtimeTableViewer.getSelection();
        if (!selection.isEmpty()) {
            log.info("RpmController TableItemSelected");
            log.finest(Messages.RpmController_TableItemSelected);
            IStructuredSelection structured = (IStructuredSelection)selection;
            Object element = structured.getFirstElement();
            if (element instanceof RuntimePlatform) {
                log.info("RuntimePlatform: isnull " + (element == null));
                log.info("RuntimePlatform: " + ((RuntimePlatform)element).getName());
                this.selectedRuntime = (RuntimePlatform)element;
                this.setDevices();
            }
            this.editRuntimeButton.setEnabled(true);
            this.editDeviceButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            log.finest(Messages.RpmController_TableItemDeselected);
            this.editRuntimeButton.setEnabled(false);
            this.editDeviceButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    private void setDevices() {
        TargetDevice targetDevice = (TargetDevice)this.selectedRuntime.getTargetDevices().get(0);
        RpmController.createDeviceList(this.deviceTableViewer, targetDevice, this.mtjServiceHandler);
    }

    private void addRuntimePlatform() {
        if (RpmUIManager.addRuntimePlatform(this.runtimeListComposite.getShell(), this.mtjServiceHandler, false) == 0) {
            RuntimePlatform newRp = this.mtjServiceHandler.getAddedRuntime();
            ((RuntimePlatformContentProvider)this.runtimeTableViewer.getContentProvider()).addVariable(this.runtimeTableViewer.getInput(), newRp);
        }
    }

    private void editRuntimePlatform(RuntimePlatform rp) {
        if (RpmUIManager.editRuntimePlatform(this.selectedRuntime, (Composite)this.runtimeListComposite) == 0) {
            this.runtimeTableViewer.refresh();
            this.setDevices();
        }
    }

    private void editDevicePlatform(RuntimePlatform rp) {
        RpmUIManager.editDevicePlatform(rp, (Composite)this.runtimeListComposite);
    }

    private void removeRuntimePlatform() {
        if (this.selectedRuntime != null) {
            Object oldInput = this.runtimeTableViewer.getInput();
            RuntimePlatform[] newInput = ((RuntimePlatformContentProvider)this.runtimeTableViewer.getContentProvider()).removeVariable(oldInput, this.selectedRuntime);
            this.runtimeTableViewer.remove((Object)this.selectedRuntime);
            this.runtimeTableViewer.setInput((Object)newInput);
            this.runtimeTableViewer.refresh();
        }
    }

    public RuntimePlatform[] getRuntimePlatforms() {
        RuntimePlatform[] runtimes = (RuntimePlatform[])this.runtimeTableViewer.getInput();
        return runtimes;
    }

    private static void createDeviceList(CheckboxTableViewer deviceTableViewer, TargetDevice targetDevice, MtjServiceHandler mtjServiceHandler) {
        if (targetDevice != null) {
            EList dl = mtjServiceHandler.getDeviceList(targetDevice.getDevicePlatformName());
            deviceTableViewer.setInput((Object)dl);
            for (Device d : dl) {
                if (!d.getName().equals(targetDevice.getDeviceName())) continue;
                deviceTableViewer.setChecked((Object)d, true);
                break;
            }
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        boolean checkState = event.getChecked();
        Object o = event.getElement();
        if (o instanceof Device) {
            Device d = (Device)o;
            this.deviceTableViewer.setAllChecked(false);
            this.deviceTableViewer.setChecked((Object)d, true);
            if (checkState) {
                this.setRuntimeDevice(d);
            }
        }
    }

    private void setRuntimeDevice(Device device) {
        String dpString = ((TargetDevice)this.selectedRuntime.getTargetDevices().get(0)).getDevicePlatformName();
        DevicePlatform dp = this.mtjServiceHandler.getDevicePlatform(dpString);
        TargetDevice td = MtjServiceHandler.createTargetDevice(dp, (RuntimePlatformDefinition)device.getRuntimePlatformDefinitions().get(0), device);
        EList l = this.selectedRuntime.getTargetDevices();
        l.clear();
        l.add((Object)td);
    }
}

