/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.rpm.preferences;

import java.util.logging.Logger;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.extension.rpm.Messages;
import org.eclipse.mtj.extension.rpm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.rpm.preferences.RpmController;
import org.eclipse.mtj.extension.rpm.ui.preferences.RuntimeListComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RpmPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static Logger log = Logger.getLogger(RpmPreferencePage.class.getName());
    private RuntimeListComposite runtimeListComposite;
    private RpmController rpmController;

    public RpmPreferencePage() {
        log.info(Messages.RpmPreferencePage_ConstructingRpmPreferencePage);
        this.setTitle(Messages.RpmPreferencePage_RuntimePlatform);
        this.setDescription(Messages.RpmPreferencePage_CreateAndModifyRuntimePlatforms);
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        this.runtimeListComposite = new RuntimeListComposite(parent);
        this.rpmController = new RpmController(this.runtimeListComposite);
        return this.runtimeListComposite;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        boolean okToStore = MtjServiceHandler.storeRuntimes(this.rpmController.getRuntimePlatforms());
        log.info("OK performed in rpm preferences page : " + okToStore);
        if (okToStore) {
            return super.performOk();
        }
        return okToStore;
    }
}

