/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.jad.util;

public class PropertyLine {
    protected String key;
    protected String value;
    protected StringBuffer leadingComments = new StringBuffer();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.getLeadingCommentLength() > 0) {
            String comment = this.getLeadingComment();
            buffer.append(comment);
            if (!comment.endsWith("\n")) {
                buffer.append('\n');
            }
        }
        buffer.append(this.key).append(": ").append(this.value);
        return buffer.toString();
    }

    public Object clone() {
        PropertyLine clone = new PropertyLine();
        clone.key = this.key;
        clone.value = this.value;
        clone.leadingComments.append(this.leadingComments.toString());
        return clone;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof PropertyLine) {
            PropertyLine otherLine = (PropertyLine)o;
            equals = otherLine.key.equals(this.key) && otherLine.value.equals(this.value) && otherLine.leadingComments.toString().equals(this.leadingComments.toString());
        }
        return equals;
    }

    public String getKey() {
        return this.key;
    }

    public String getLeadingComment() {
        return this.leadingComments.toString();
    }

    public void setLeadingComment(String comments) {
        this.leadingComments.setLength(0);
        this.leadingComments.append(comments);
    }

    public void appendToLeadingComments(String comments) {
        this.leadingComments.append(comments);
    }

    public int getLeadingCommentLength() {
        return this.leadingComments.length();
    }

    public String getValue() {
        return this.value;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

