/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.bp.eclipse.javame;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.extension.PackagingProvider;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.core.util.EclipseUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.bp.eclipse.BuildProviderUtil;

public class JavaMePackaging {
    private IMtjProject mtjProject;
    private IFolder binaryFolder;
    private IFolder deploymentFolder;
    private IProgressMonitor monitor;

    public JavaMePackaging(IMtjProject mtjProject, IProgressMonitor monitor) {
        this.mtjProject = mtjProject;
        this.monitor = monitor;
    }

    public void performPackaging(String natureId) throws MtjException, CoreException {
        DeploymentType dtype = BuildProviderUtil.getDeploymentType(this.mtjProject);
        PackagingProvider provider = BuildProviderUtil.getPackagingProvider(this.mtjProject, dtype);
        IResource[] iResourceArray = new IResource[2];
        iResourceArray[0] = this.getBinaryFolder();
        IResource[] outputResources = iResourceArray;
        provider.createDeployment(this.mtjProject.getProject().getName(), this.mtjProject.getProjectData(), outputResources, this.getDeploymentFolder(), dtype, natureId, this.monitor);
        EclipseUtil.setResourcesAsDerived((IContainer)this.getDeploymentFolder());
    }

    public IFolder getDeploymentFolder() throws CoreException {
        if (this.deploymentFolder == null) {
            this.deploymentFolder = this.mtjProject.getDeploymentFolder(this.monitor);
            if (this.deploymentFolder.exists()) {
                this.deploymentFolder.delete(true, this.monitor);
            }
            this.deploymentFolder.create(true, true, this.monitor);
        }
        if (!this.deploymentFolder.exists()) {
            this.deploymentFolder.create(true, true, this.monitor);
        }
        return this.deploymentFolder;
    }

    public void setDeploymentFolder(IFolder deploymentFolder) throws CoreException {
        if (deploymentFolder.exists()) {
            deploymentFolder.delete(true, this.monitor);
        }
        deploymentFolder.create(true, true, this.monitor);
        this.deploymentFolder = deploymentFolder;
    }

    public IFolder getBinaryFolder() throws CoreException {
        if (this.binaryFolder == null) {
            this.binaryFolder = this.mtjProject.getClassesOutputFolder(this.monitor);
        }
        return this.binaryFolder;
    }

    public void setBinaryFolder(IFolder outputFolder) {
        this.binaryFolder = outputFolder;
    }
}

