/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.bp.eclipse.midp;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.PreverificationProvider;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.preverifier.PreverificationError;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.exception.PreverificationException;

public class MidpPreverify {
    private IProgressMonitor monitor;
    private IMtjProject mtjProject;
    private IFolder preverifiedOutputDir = null;
    private IFolder classesDir = null;

    public MidpPreverify(IMtjProject project, IProgressMonitor monitor) {
        this.mtjProject = project;
        this.monitor = monitor;
    }

    public void performPreverify(RuntimePlatformDefinition targetPlatform) throws MtjException, CoreException {
        PreverificationProvider provider;
        MtjExtension[] extensions = MtjServices.getInstance().getImplementations(ExtensionType.PREVERIFICATION_PROVIDER_LITERAL, null, null, true);
        PreverificationProvider preverificationProvider = provider = extensions.length > 0 ? (PreverificationProvider)extensions[0] : null;
        if (provider == null) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)10002));
        }
        IResource[] resource = new IResource[]{this.getClassesDir()};
        PreverificationError[] preverificationError = provider.preverify(this.mtjProject, targetPlatform, resource, this.getOutputFolder(), this.monitor);
        if (preverificationError.length > 0) {
            PreverificationException ex = new PreverificationException(MtjCoreErrors.getErrorMessage((int)10003));
            ex.setPreverificationError(preverificationError);
            throw ex;
        }
    }

    public IFolder getOutputFolder() throws CoreException {
        if (this.preverifiedOutputDir == null) {
            this.preverifiedOutputDir = this.mtjProject.getVerifiedClassesOutputFolder(this.monitor);
            if (this.preverifiedOutputDir.exists()) {
                this.preverifiedOutputDir.delete(true, this.monitor);
            }
            this.preverifiedOutputDir.create(true, true, this.monitor);
        }
        if (!this.preverifiedOutputDir.exists()) {
            this.preverifiedOutputDir.create(true, true, this.monitor);
        }
        return this.preverifiedOutputDir;
    }

    public void setOutputFolder(IFolder outputFolder) throws CoreException {
        if (outputFolder.exists()) {
            outputFolder.delete(true, this.monitor);
        }
        outputFolder.create(true, true, this.monitor);
        this.preverifiedOutputDir = outputFolder;
    }

    public IFolder getClassesDir() throws CoreException {
        if (this.classesDir == null) {
            this.classesDir = this.mtjProject.getClassesOutputFolder(this.monitor);
        }
        return this.classesDir;
    }

    public void setClassesDir(IFolder binaryFilesDir) {
        this.classesDir = binaryFilesDir;
    }
}

