/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.enumerations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Action Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.enumerations.EnumerationsPackage#getActionType()
 * @model
 * @generated
 */
public final class ActionType extends AbstractEnumerator {
	/**
	 * The '<em><b>ACTION TYPE IF ELSE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACTION TYPE IF ELSE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACTION_TYPE_IF_ELSE_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACTION_TYPE_IF_ELSE = 0;

	/**
	 * The '<em><b>ACTION TYPE ELSE IF</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACTION TYPE ELSE IF</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACTION_TYPE_ELSE_IF_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACTION_TYPE_ELSE_IF = 1;

	/**
	 * The '<em><b>ACTION TYPE IF NOT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACTION TYPE IF NOT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACTION_TYPE_IF_NOT_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACTION_TYPE_IF_NOT = 2;

	/**
	 * The '<em><b>ACTION TYPE NOT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACTION TYPE NOT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACTION_TYPE_NOT_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACTION_TYPE_NOT = 3;

	/**
	 * The '<em><b>ACTION TYPE DEBUG</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACTION TYPE DEBUG</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACTION_TYPE_DEBUG_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACTION_TYPE_DEBUG = 4;

	/**
	 * The '<em><b>ACTION TYPE IF ELSE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACTION_TYPE_IF_ELSE
	 * @generated
	 * @ordered
	 */
	public static final ActionType ACTION_TYPE_IF_ELSE_LITERAL = new ActionType(ACTION_TYPE_IF_ELSE, "ACTION_TYPE_IF_ELSE");

	/**
	 * The '<em><b>ACTION TYPE ELSE IF</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACTION_TYPE_ELSE_IF
	 * @generated
	 * @ordered
	 */
	public static final ActionType ACTION_TYPE_ELSE_IF_LITERAL = new ActionType(ACTION_TYPE_ELSE_IF, "ACTION_TYPE_ELSE_IF");

	/**
	 * The '<em><b>ACTION TYPE IF NOT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACTION_TYPE_IF_NOT
	 * @generated
	 * @ordered
	 */
	public static final ActionType ACTION_TYPE_IF_NOT_LITERAL = new ActionType(ACTION_TYPE_IF_NOT, "ACTION_TYPE_IF_NOT");

	/**
	 * The '<em><b>ACTION TYPE NOT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACTION_TYPE_NOT
	 * @generated
	 * @ordered
	 */
	public static final ActionType ACTION_TYPE_NOT_LITERAL = new ActionType(ACTION_TYPE_NOT, "ACTION_TYPE_NOT");

	/**
	 * The '<em><b>ACTION TYPE DEBUG</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACTION_TYPE_DEBUG
	 * @generated
	 * @ordered
	 */
	public static final ActionType ACTION_TYPE_DEBUG_LITERAL = new ActionType(ACTION_TYPE_DEBUG, "ACTION_TYPE_DEBUG");

	/**
	 * An array of all the '<em><b>Action Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ActionType[] VALUES_ARRAY =
		new ActionType[] {
			ACTION_TYPE_IF_ELSE_LITERAL,
			ACTION_TYPE_ELSE_IF_LITERAL,
			ACTION_TYPE_IF_NOT_LITERAL,
			ACTION_TYPE_NOT_LITERAL,
			ACTION_TYPE_DEBUG_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Action Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Action Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ActionType get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ActionType result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Action Type</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ActionType get(int value) {
		switch (value) {
			case ACTION_TYPE_IF_ELSE: return ACTION_TYPE_IF_ELSE_LITERAL;
			case ACTION_TYPE_ELSE_IF: return ACTION_TYPE_ELSE_IF_LITERAL;
			case ACTION_TYPE_IF_NOT: return ACTION_TYPE_IF_NOT_LITERAL;
			case ACTION_TYPE_NOT: return ACTION_TYPE_NOT_LITERAL;
			case ACTION_TYPE_DEBUG: return ACTION_TYPE_DEBUG_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ActionType(int value, String name) {
		super(value, name);
	}

} //ActionType
