/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.enumerations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Build Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.enumerations.EnumerationsPackage#getBuildType()
 * @model
 * @generated
 */
public final class BuildType extends AbstractEnumerator {
	/**
	 * The '<em><b>BUILD TYPE ANT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>BUILD TYPE ANT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BUILD_TYPE_ANT_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BUILD_TYPE_ANT = 0;

	/**
	 * The '<em><b>BUILD TYPE ECLIPSE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>BUILD TYPE ECLIPSE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BUILD_TYPE_ECLIPSE_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BUILD_TYPE_ECLIPSE = 1;

	/**
	 * The '<em><b>BUILD TYPE ANT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BUILD_TYPE_ANT
	 * @generated
	 * @ordered
	 */
	public static final BuildType BUILD_TYPE_ANT_LITERAL = new BuildType(BUILD_TYPE_ANT, "BUILD_TYPE_ANT");

	/**
	 * The '<em><b>BUILD TYPE ECLIPSE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BUILD_TYPE_ECLIPSE
	 * @generated
	 * @ordered
	 */
	public static final BuildType BUILD_TYPE_ECLIPSE_LITERAL = new BuildType(BUILD_TYPE_ECLIPSE, "BUILD_TYPE_ECLIPSE");

	/**
	 * An array of all the '<em><b>Build Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final BuildType[] VALUES_ARRAY =
		new BuildType[] {
			BUILD_TYPE_ANT_LITERAL,
			BUILD_TYPE_ECLIPSE_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Build Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Build Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static BuildType get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			BuildType result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Build Type</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static BuildType get(int value) {
		switch (value) {
			case BUILD_TYPE_ANT: return BUILD_TYPE_ANT_LITERAL;
			case BUILD_TYPE_ECLIPSE: return BUILD_TYPE_ECLIPSE_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private BuildType(int value, String name) {
		super(value, name);
	}

} //BuildType
