/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.enumerations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Project Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.enumerations.EnumerationsPackage#getProjectType()
 * @model
 * @generated
 */
public final class ProjectType extends AbstractEnumerator {
	/**
	 * The '<em><b>PROJECT TYPE MIDP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PROJECT TYPE MIDP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PROJECT_TYPE_MIDP_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PROJECT_TYPE_MIDP = 0;

	/**
	 * The '<em><b>PROJECT TYPE PERSONAL PROFILE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PROJECT TYPE PERSONAL PROFILE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PROJECT_TYPE_PERSONAL_PROFILE_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PROJECT_TYPE_PERSONAL_PROFILE = 1;

	/**
	 * The '<em><b>PROJECT TYPE MIDP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROJECT_TYPE_MIDP
	 * @generated
	 * @ordered
	 */
	public static final ProjectType PROJECT_TYPE_MIDP_LITERAL = new ProjectType(PROJECT_TYPE_MIDP, "PROJECT_TYPE_MIDP");

	/**
	 * The '<em><b>PROJECT TYPE PERSONAL PROFILE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROJECT_TYPE_PERSONAL_PROFILE
	 * @generated
	 * @ordered
	 */
	public static final ProjectType PROJECT_TYPE_PERSONAL_PROFILE_LITERAL = new ProjectType(PROJECT_TYPE_PERSONAL_PROFILE, "PROJECT_TYPE_PERSONAL_PROFILE");

	/**
	 * An array of all the '<em><b>Project Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ProjectType[] VALUES_ARRAY =
		new ProjectType[] {
			PROJECT_TYPE_MIDP_LITERAL,
			PROJECT_TYPE_PERSONAL_PROFILE_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Project Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Project Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ProjectType get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ProjectType result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Project Type</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ProjectType get(int value) {
		switch (value) {
			case PROJECT_TYPE_MIDP: return PROJECT_TYPE_MIDP_LITERAL;
			case PROJECT_TYPE_PERSONAL_PROFILE: return PROJECT_TYPE_PERSONAL_PROFILE_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ProjectType(int value, String name) {
		super(value, name);
	}

} //ProjectType
