/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.enumerations.impl;

import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.mtj.api.deployment.DeploymentPackage;

import org.eclipse.mtj.api.deployment.impl.DeploymentPackageImpl;

import org.eclipse.mtj.api.devices.DevicesPackage;

import org.eclipse.mtj.api.devices.impl.DevicesPackageImpl;

import org.eclipse.mtj.api.enumerations.ActionType;
import org.eclipse.mtj.api.enumerations.BuildType;
import org.eclipse.mtj.api.enumerations.Capability;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol;
import org.eclipse.mtj.api.enumerations.DeviceStatus;
import org.eclipse.mtj.api.enumerations.EnumerationsFactory;
import org.eclipse.mtj.api.enumerations.EnumerationsPackage;
import org.eclipse.mtj.api.enumerations.Expression;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.enumerations.PlatformType;
import org.eclipse.mtj.api.enumerations.ProjectType;

import org.eclipse.mtj.api.extension.ExtensionPackage;

import org.eclipse.mtj.api.extension.impl.ExtensionPackageImpl;

import org.eclipse.mtj.api.preprocessing.PreprocessingPackage;

import org.eclipse.mtj.api.preprocessing.impl.PreprocessingPackageImpl;

import org.eclipse.mtj.api.project.ProjectPackage;

import org.eclipse.mtj.api.project.impl.ProjectPackageImpl;

import org.eclipse.mtj.api.runtimes.RuntimesPackage;

import org.eclipse.mtj.api.runtimes.impl.RuntimesPackageImpl;

import org.eclipse.mtj.api.signings.SigningsPackage;

import org.eclipse.mtj.api.signings.impl.SigningsPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class EnumerationsPackageImpl extends EPackageImpl implements EnumerationsPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum capabilityEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum buildTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum extensionTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum actionTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum deploymentTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum deviceCommunicationProtocolEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum platformTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum expressionEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum projectTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum deviceStatusEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.mtj.api.enumerations.EnumerationsPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private EnumerationsPackageImpl() {
		super(eNS_URI, EnumerationsFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static EnumerationsPackage init() {
		if (isInited) return (EnumerationsPackage)EPackage.Registry.INSTANCE.getEPackage(EnumerationsPackage.eNS_URI);

		// Obtain or create and register package
		EnumerationsPackageImpl theEnumerationsPackage = (EnumerationsPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof EnumerationsPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new EnumerationsPackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies
		DevicesPackageImpl theDevicesPackage = (DevicesPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(DevicesPackage.eNS_URI) instanceof DevicesPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(DevicesPackage.eNS_URI) : DevicesPackage.eINSTANCE);
		ExtensionPackageImpl theExtensionPackage = (ExtensionPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ExtensionPackage.eNS_URI) instanceof ExtensionPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ExtensionPackage.eNS_URI) : ExtensionPackage.eINSTANCE);
		ProjectPackageImpl theProjectPackage = (ProjectPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ProjectPackage.eNS_URI) instanceof ProjectPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ProjectPackage.eNS_URI) : ProjectPackage.eINSTANCE);
		RuntimesPackageImpl theRuntimesPackage = (RuntimesPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(RuntimesPackage.eNS_URI) instanceof RuntimesPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(RuntimesPackage.eNS_URI) : RuntimesPackage.eINSTANCE);
		PreprocessingPackageImpl thePreprocessingPackage = (PreprocessingPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(PreprocessingPackage.eNS_URI) instanceof PreprocessingPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(PreprocessingPackage.eNS_URI) : PreprocessingPackage.eINSTANCE);
		DeploymentPackageImpl theDeploymentPackage = (DeploymentPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(DeploymentPackage.eNS_URI) instanceof DeploymentPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(DeploymentPackage.eNS_URI) : DeploymentPackage.eINSTANCE);
		SigningsPackageImpl theSigningsPackage = (SigningsPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(SigningsPackage.eNS_URI) instanceof SigningsPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(SigningsPackage.eNS_URI) : SigningsPackage.eINSTANCE);

		// Create package meta-data objects
		theEnumerationsPackage.createPackageContents();
		theDevicesPackage.createPackageContents();
		theExtensionPackage.createPackageContents();
		theProjectPackage.createPackageContents();
		theRuntimesPackage.createPackageContents();
		thePreprocessingPackage.createPackageContents();
		theDeploymentPackage.createPackageContents();
		theSigningsPackage.createPackageContents();

		// Initialize created meta-data
		theEnumerationsPackage.initializePackageContents();
		theDevicesPackage.initializePackageContents();
		theExtensionPackage.initializePackageContents();
		theProjectPackage.initializePackageContents();
		theRuntimesPackage.initializePackageContents();
		thePreprocessingPackage.initializePackageContents();
		theDeploymentPackage.initializePackageContents();
		theSigningsPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theEnumerationsPackage.freeze();

		return theEnumerationsPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getCapability() {
		return capabilityEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getBuildType() {
		return buildTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getExtensionType() {
		return extensionTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getActionType() {
		return actionTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getDeploymentType() {
		return deploymentTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getDeviceCommunicationProtocol() {
		return deviceCommunicationProtocolEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getPlatformType() {
		return platformTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getExpression() {
		return expressionEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getProjectType() {
		return projectTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getDeviceStatus() {
		return deviceStatusEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EnumerationsFactory getEnumerationsFactory() {
		return (EnumerationsFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create enums
		capabilityEEnum = createEEnum(CAPABILITY);
		buildTypeEEnum = createEEnum(BUILD_TYPE);
		extensionTypeEEnum = createEEnum(EXTENSION_TYPE);
		actionTypeEEnum = createEEnum(ACTION_TYPE);
		deploymentTypeEEnum = createEEnum(DEPLOYMENT_TYPE);
		deviceCommunicationProtocolEEnum = createEEnum(DEVICE_COMMUNICATION_PROTOCOL);
		platformTypeEEnum = createEEnum(PLATFORM_TYPE);
		expressionEEnum = createEEnum(EXPRESSION);
		projectTypeEEnum = createEEnum(PROJECT_TYPE);
		deviceStatusEEnum = createEEnum(DEVICE_STATUS);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Initialize enums and add enum literals
		initEEnum(capabilityEEnum, Capability.class, "Capability");
		addEEnumLiteral(capabilityEEnum, Capability.BITS_PER_PIXEL_LITERAL);
		addEEnumLiteral(capabilityEEnum, Capability.SCREEN_SIZE_LITERAL);
		addEEnumLiteral(capabilityEEnum, Capability.CANVAS_SIZE_LITERAL);
		addEEnumLiteral(capabilityEEnum, Capability.CAMERA_RESOLUTION_LITERAL);
		addEEnumLiteral(capabilityEEnum, Capability.DEVICE_PROFILE_LITERAL);
		addEEnumLiteral(capabilityEEnum, Capability.DEVICE_CONFIGURATION_LITERAL);
		addEEnumLiteral(capabilityEEnum, Capability.SERVICE_API_LITERAL);
		addEEnumLiteral(capabilityEEnum, Capability.JAVA_PROTOCOL_LITERAL);
		addEEnumLiteral(capabilityEEnum, Capability.HEAP_SIZE_LITERAL);
		addEEnumLiteral(capabilityEEnum, Capability.MAX_JAR_SIZE_LITERAL);
		addEEnumLiteral(capabilityEEnum, Capability.OS_LITERAL);
		addEEnumLiteral(capabilityEEnum, Capability.VIDEO_FORMAT_LITERAL);
		addEEnumLiteral(capabilityEEnum, Capability.SOUND_FORMAT_LITERAL);

		initEEnum(buildTypeEEnum, BuildType.class, "BuildType");
		addEEnumLiteral(buildTypeEEnum, BuildType.BUILD_TYPE_ANT_LITERAL);
		addEEnumLiteral(buildTypeEEnum, BuildType.BUILD_TYPE_ECLIPSE_LITERAL);

		initEEnum(extensionTypeEEnum, ExtensionType.class, "ExtensionType");
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.ADMIN_GUI_PROVIDER_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.BUILD_MANAGEMENT_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.BUILD_PROVIDER_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.DEPLOYMENT_MANAGEMENT_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.GUI_BUILDER_MANAGEMENT_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.GUI_BUILDER_PROVIDER_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.PACKAGING_PROVIDER_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.PREPROCESSING_PROVIDER_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.OBFUSCATION_PROVIDER_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.SCREEN_ENGINE_PROVIDER_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.SECURITY_MANAGEMENT_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.SIGNING_PROVIDER_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.DRM_ENCODING_PROVIDER_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.DEVICE_MANAGEMENT_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.DEVICE_DESCRIPTION_PROVIDER_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.DEPLOYMENT_PROVIDER_LITERAL);
		addEEnumLiteral(extensionTypeEEnum, ExtensionType.PREVERIFICATION_PROVIDER_LITERAL);

		initEEnum(actionTypeEEnum, ActionType.class, "ActionType");
		addEEnumLiteral(actionTypeEEnum, ActionType.ACTION_TYPE_IF_ELSE_LITERAL);
		addEEnumLiteral(actionTypeEEnum, ActionType.ACTION_TYPE_ELSE_IF_LITERAL);
		addEEnumLiteral(actionTypeEEnum, ActionType.ACTION_TYPE_IF_NOT_LITERAL);
		addEEnumLiteral(actionTypeEEnum, ActionType.ACTION_TYPE_NOT_LITERAL);
		addEEnumLiteral(actionTypeEEnum, ActionType.ACTION_TYPE_DEBUG_LITERAL);

		initEEnum(deploymentTypeEEnum, DeploymentType.class, "DeploymentType");
		addEEnumLiteral(deploymentTypeEEnum, DeploymentType.DEPLOYMENT_TYPE_MIDLET_LITERAL);
		addEEnumLiteral(deploymentTypeEEnum, DeploymentType.DEPLOYMENT_TYPE_CDC_LITERAL);
		addEEnumLiteral(deploymentTypeEEnum, DeploymentType.DEPLOYMENT_TYPE_OSGI_MIDLET_LITERAL);
		addEEnumLiteral(deploymentTypeEEnum, DeploymentType.DEPLOYMENT_TYPE_RESOURCE_LITERAL);

		initEEnum(deviceCommunicationProtocolEEnum, DeviceCommunicationProtocol.class, "DeviceCommunicationProtocol");
		addEEnumLiteral(deviceCommunicationProtocolEEnum, DeviceCommunicationProtocol.PROTOCOL_UEI_LITERAL);
		addEEnumLiteral(deviceCommunicationProtocolEEnum, DeviceCommunicationProtocol.PROTOCOL_XEI_LITERAL);
		addEEnumLiteral(deviceCommunicationProtocolEEnum, DeviceCommunicationProtocol.PROTOCOL_OTA_LITERAL);
		addEEnumLiteral(deviceCommunicationProtocolEEnum, DeviceCommunicationProtocol.PROTOCOL_OBEX_LITERAL);
		addEEnumLiteral(deviceCommunicationProtocolEEnum, DeviceCommunicationProtocol.PROTOCOL_OTHER_LITERAL);

		initEEnum(platformTypeEEnum, PlatformType.class, "PlatformType");
		addEEnumLiteral(platformTypeEEnum, PlatformType.EXECUTABLE_EMULATOR_LITERAL);
		addEEnumLiteral(platformTypeEEnum, PlatformType.JAVA_BASED_EMULATOR_LITERAL);
		addEEnumLiteral(platformTypeEEnum, PlatformType.OTA_EMULATOR_LITERAL);
		addEEnumLiteral(platformTypeEEnum, PlatformType.REAL_DEVICE_LITERAL);

		initEEnum(expressionEEnum, Expression.class, "Expression");
		addEEnumLiteral(expressionEEnum, Expression.EXPRESSION_LT_LITERAL);
		addEEnumLiteral(expressionEEnum, Expression.EXPRESSION_LET_LITERAL);
		addEEnumLiteral(expressionEEnum, Expression.EXPRESSION_EQ_LITERAL);
		addEEnumLiteral(expressionEEnum, Expression.EXPRESSION_NEQ_LITERAL);
		addEEnumLiteral(expressionEEnum, Expression.EXPRESSION_GET_LITERAL);
		addEEnumLiteral(expressionEEnum, Expression.EXPRESSION_GT_LITERAL);

		initEEnum(projectTypeEEnum, ProjectType.class, "ProjectType");
		addEEnumLiteral(projectTypeEEnum, ProjectType.PROJECT_TYPE_MIDP_LITERAL);
		addEEnumLiteral(projectTypeEEnum, ProjectType.PROJECT_TYPE_PERSONAL_PROFILE_LITERAL);

		initEEnum(deviceStatusEEnum, DeviceStatus.class, "DeviceStatus");
		addEEnumLiteral(deviceStatusEEnum, DeviceStatus.DEVICE_STATUS_OK_LITERAL);
		addEEnumLiteral(deviceStatusEEnum, DeviceStatus.DEVICE_STATUS_ERROR_LITERAL);
		addEEnumLiteral(deviceStatusEEnum, DeviceStatus.DEVICE_STATUS_NOT_CONNECTED_LITERAL);
		addEEnumLiteral(deviceStatusEEnum, DeviceStatus.DEVICE_STATUS_UNKNOWN_LITERAL);

		// Create resource
		createResource(eNS_URI);
	}

} //EnumerationsPackageImpl
