/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.extension.ExtensionFactory
 * @model kind="package"
 * @generated
 */
public interface ExtensionPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "extension";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http:///org/eclipse/mtj/api/extension.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "org.eclipse.mtj.api.extension";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ExtensionPackage eINSTANCE = org.eclipse.mtj.api.extension.impl.ExtensionPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.extension.impl.MtjExtensionImpl <em>Mtj Extension</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.extension.impl.MtjExtensionImpl
	 * @see org.eclipse.mtj.api.extension.impl.ExtensionPackageImpl#getMtjExtension()
	 * @generated
	 */
	int MTJ_EXTENSION = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MTJ_EXTENSION__ID = 0;

	/**
	 * The feature id for the '<em><b>Vendor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MTJ_EXTENSION__VENDOR = 1;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MTJ_EXTENSION__VERSION = 2;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MTJ_EXTENSION__DESCRIPTION = 3;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MTJ_EXTENSION__TYPE = 4;

	/**
	 * The feature id for the '<em><b>Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MTJ_EXTENSION__ACTIVE = 5;

	/**
	 * The number of structural features of the the '<em>Mtj Extension</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MTJ_EXTENSION_FEATURE_COUNT = 6;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.extension.impl.BuildExtensionImpl <em>Build Extension</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.extension.impl.BuildExtensionImpl
	 * @see org.eclipse.mtj.api.extension.impl.ExtensionPackageImpl#getBuildExtension()
	 * @generated
	 */
	int BUILD_EXTENSION = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BUILD_EXTENSION__ID = MTJ_EXTENSION__ID;

	/**
	 * The feature id for the '<em><b>Vendor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BUILD_EXTENSION__VENDOR = MTJ_EXTENSION__VENDOR;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BUILD_EXTENSION__VERSION = MTJ_EXTENSION__VERSION;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BUILD_EXTENSION__DESCRIPTION = MTJ_EXTENSION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BUILD_EXTENSION__TYPE = MTJ_EXTENSION__TYPE;

	/**
	 * The feature id for the '<em><b>Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BUILD_EXTENSION__ACTIVE = MTJ_EXTENSION__ACTIVE;

	/**
	 * The feature id for the '<em><b>Ext Jar</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BUILD_EXTENSION__EXT_JAR = MTJ_EXTENSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Build Extension</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BUILD_EXTENSION_FEATURE_COUNT = MTJ_EXTENSION_FEATURE_COUNT + 1;


	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.extension.MtjExtension <em>Mtj Extension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Mtj Extension</em>'.
	 * @see org.eclipse.mtj.api.extension.MtjExtension
	 * @generated
	 */
	EClass getMtjExtension();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.extension.MtjExtension#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.mtj.api.extension.MtjExtension#getId()
	 * @see #getMtjExtension()
	 * @generated
	 */
	EAttribute getMtjExtension_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.extension.MtjExtension#getVendor <em>Vendor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Vendor</em>'.
	 * @see org.eclipse.mtj.api.extension.MtjExtension#getVendor()
	 * @see #getMtjExtension()
	 * @generated
	 */
	EAttribute getMtjExtension_Vendor();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.extension.MtjExtension#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.eclipse.mtj.api.extension.MtjExtension#getVersion()
	 * @see #getMtjExtension()
	 * @generated
	 */
	EAttribute getMtjExtension_Version();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.extension.MtjExtension#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.mtj.api.extension.MtjExtension#getDescription()
	 * @see #getMtjExtension()
	 * @generated
	 */
	EAttribute getMtjExtension_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.extension.MtjExtension#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.mtj.api.extension.MtjExtension#getType()
	 * @see #getMtjExtension()
	 * @generated
	 */
	EAttribute getMtjExtension_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.extension.MtjExtension#isActive <em>Active</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Active</em>'.
	 * @see org.eclipse.mtj.api.extension.MtjExtension#isActive()
	 * @see #getMtjExtension()
	 * @generated
	 */
	EAttribute getMtjExtension_Active();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.extension.BuildExtension <em>Build Extension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Build Extension</em>'.
	 * @see org.eclipse.mtj.api.extension.BuildExtension
	 * @generated
	 */
	EClass getBuildExtension();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.extension.BuildExtension#getExtJar <em>Ext Jar</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ext Jar</em>'.
	 * @see org.eclipse.mtj.api.extension.BuildExtension#getExtJar()
	 * @see #getBuildExtension()
	 * @generated
	 */
	EAttribute getBuildExtension_ExtJar();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ExtensionFactory getExtensionFactory();

} //ExtensionPackage
