/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.extension.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.mtj.api.enumerations.ExtensionType;

import org.eclipse.mtj.api.extension.BuildExtension;
import org.eclipse.mtj.api.extension.ExtensionPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Build Extension</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.extension.impl.BuildExtensionImpl#getExtJar <em>Ext Jar</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BuildExtensionImpl extends MtjExtensionImpl implements BuildExtension {
	/**
	 * The default value of the '{@link #getExtJar() <em>Ext Jar</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExtJar()
	 * @generated
	 * @ordered
	 */
	protected static final String EXT_JAR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getExtJar() <em>Ext Jar</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExtJar()
	 * @generated
	 * @ordered
	 */
	protected String extJar = EXT_JAR_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BuildExtensionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ExtensionPackage.eINSTANCE.getBuildExtension();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getExtJar() {
		return extJar;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExtJar(String newExtJar) {
		String oldExtJar = extJar;
		extJar = newExtJar;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionPackage.BUILD_EXTENSION__EXT_JAR, oldExtJar, extJar));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionPackage.BUILD_EXTENSION__ID:
				return getId();
			case ExtensionPackage.BUILD_EXTENSION__VENDOR:
				return getVendor();
			case ExtensionPackage.BUILD_EXTENSION__VERSION:
				return getVersion();
			case ExtensionPackage.BUILD_EXTENSION__DESCRIPTION:
				return getDescription();
			case ExtensionPackage.BUILD_EXTENSION__TYPE:
				return getType();
			case ExtensionPackage.BUILD_EXTENSION__ACTIVE:
				return isActive() ? Boolean.TRUE : Boolean.FALSE;
			case ExtensionPackage.BUILD_EXTENSION__EXT_JAR:
				return getExtJar();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionPackage.BUILD_EXTENSION__ID:
				setId((String)newValue);
				return;
			case ExtensionPackage.BUILD_EXTENSION__VENDOR:
				setVendor((String)newValue);
				return;
			case ExtensionPackage.BUILD_EXTENSION__VERSION:
				setVersion((String)newValue);
				return;
			case ExtensionPackage.BUILD_EXTENSION__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case ExtensionPackage.BUILD_EXTENSION__TYPE:
				setType((ExtensionType)newValue);
				return;
			case ExtensionPackage.BUILD_EXTENSION__ACTIVE:
				setActive(((Boolean)newValue).booleanValue());
				return;
			case ExtensionPackage.BUILD_EXTENSION__EXT_JAR:
				setExtJar((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionPackage.BUILD_EXTENSION__ID:
				setId(ID_EDEFAULT);
				return;
			case ExtensionPackage.BUILD_EXTENSION__VENDOR:
				setVendor(VENDOR_EDEFAULT);
				return;
			case ExtensionPackage.BUILD_EXTENSION__VERSION:
				setVersion(VERSION_EDEFAULT);
				return;
			case ExtensionPackage.BUILD_EXTENSION__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case ExtensionPackage.BUILD_EXTENSION__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case ExtensionPackage.BUILD_EXTENSION__ACTIVE:
				setActive(ACTIVE_EDEFAULT);
				return;
			case ExtensionPackage.BUILD_EXTENSION__EXT_JAR:
				setExtJar(EXT_JAR_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionPackage.BUILD_EXTENSION__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case ExtensionPackage.BUILD_EXTENSION__VENDOR:
				return VENDOR_EDEFAULT == null ? vendor != null : !VENDOR_EDEFAULT.equals(vendor);
			case ExtensionPackage.BUILD_EXTENSION__VERSION:
				return VERSION_EDEFAULT == null ? version != null : !VERSION_EDEFAULT.equals(version);
			case ExtensionPackage.BUILD_EXTENSION__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case ExtensionPackage.BUILD_EXTENSION__TYPE:
				return type != TYPE_EDEFAULT;
			case ExtensionPackage.BUILD_EXTENSION__ACTIVE:
				return active != ACTIVE_EDEFAULT;
			case ExtensionPackage.BUILD_EXTENSION__EXT_JAR:
				return EXT_JAR_EDEFAULT == null ? extJar != null : !EXT_JAR_EDEFAULT.equals(extJar);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (extJar: ");
		result.append(extJar);
		result.append(')');
		return result.toString();
	}

} //BuildExtensionImpl
