/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.preprocessing;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.preprocessing.PreprocessingFactory
 * @model kind="package"
 * @generated
 */
public interface PreprocessingPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "preprocessing";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http:///org/eclipse/mtj/api/preprocessing.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "org.eclipse.mtj.api.preprocessing";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	PreprocessingPackage eINSTANCE = org.eclipse.mtj.api.preprocessing.impl.PreprocessingPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.preprocessing.impl.ConditionImpl <em>Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.preprocessing.impl.ConditionImpl
	 * @see org.eclipse.mtj.api.preprocessing.impl.PreprocessingPackageImpl#getCondition()
	 * @generated
	 */
	int CONDITION = 1;

	/**
	 * The number of structural features of the the '<em>Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITION_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.preprocessing.impl.CapabilityConditionImpl <em>Capability Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.preprocessing.impl.CapabilityConditionImpl
	 * @see org.eclipse.mtj.api.preprocessing.impl.PreprocessingPackageImpl#getCapabilityCondition()
	 * @generated
	 */
	int CAPABILITY_CONDITION = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAPABILITY_CONDITION__NAME = CONDITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAPABILITY_CONDITION__EXPRESSION = CONDITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAPABILITY_CONDITION__VALUE = CONDITION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the the '<em>Capability Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAPABILITY_CONDITION_FEATURE_COUNT = CONDITION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.preprocessing.impl.FeatureConditionImpl <em>Feature Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.preprocessing.impl.FeatureConditionImpl
	 * @see org.eclipse.mtj.api.preprocessing.impl.PreprocessingPackageImpl#getFeatureCondition()
	 * @generated
	 */
	int FEATURE_CONDITION = 2;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_CONDITION__FEATURE = CONDITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Feature Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_CONDITION_FEATURE_COUNT = CONDITION_FEATURE_COUNT + 1;


	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.preprocessing.CapabilityCondition <em>Capability Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Capability Condition</em>'.
	 * @see org.eclipse.mtj.api.preprocessing.CapabilityCondition
	 * @generated
	 */
	EClass getCapabilityCondition();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.preprocessing.CapabilityCondition#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.preprocessing.CapabilityCondition#getName()
	 * @see #getCapabilityCondition()
	 * @generated
	 */
	EAttribute getCapabilityCondition_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.preprocessing.CapabilityCondition#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Expression</em>'.
	 * @see org.eclipse.mtj.api.preprocessing.CapabilityCondition#getExpression()
	 * @see #getCapabilityCondition()
	 * @generated
	 */
	EAttribute getCapabilityCondition_Expression();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.preprocessing.CapabilityCondition#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.mtj.api.preprocessing.CapabilityCondition#getValue()
	 * @see #getCapabilityCondition()
	 * @generated
	 */
	EAttribute getCapabilityCondition_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.preprocessing.Condition <em>Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Condition</em>'.
	 * @see org.eclipse.mtj.api.preprocessing.Condition
	 * @generated
	 */
	EClass getCondition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.preprocessing.FeatureCondition <em>Feature Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Feature Condition</em>'.
	 * @see org.eclipse.mtj.api.preprocessing.FeatureCondition
	 * @generated
	 */
	EClass getFeatureCondition();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.preprocessing.FeatureCondition#getFeature <em>Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Feature</em>'.
	 * @see org.eclipse.mtj.api.preprocessing.FeatureCondition#getFeature()
	 * @see #getFeatureCondition()
	 * @generated
	 */
	EAttribute getFeatureCondition_Feature();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	PreprocessingFactory getPreprocessingFactory();

} //PreprocessingPackage
