/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.project.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.mtj.api.project.PackagingDetails;
import org.eclipse.mtj.api.project.Parameter;
import org.eclipse.mtj.api.project.ProjectPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Packaging Details</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.project.impl.PackagingDetailsImpl#isIncrementVersionAutomatically <em>Increment Version Automatically</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.PackagingDetailsImpl#getExculedManifestEntries <em>Exculed Manifest Entries</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class PackagingDetailsImpl extends EObjectImpl implements PackagingDetails {
	/**
	 * The default value of the '{@link #isIncrementVersionAutomatically() <em>Increment Version Automatically</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIncrementVersionAutomatically()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INCREMENT_VERSION_AUTOMATICALLY_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIncrementVersionAutomatically() <em>Increment Version Automatically</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIncrementVersionAutomatically()
	 * @generated
	 * @ordered
	 */
	protected boolean incrementVersionAutomatically = INCREMENT_VERSION_AUTOMATICALLY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getExculedManifestEntries() <em>Exculed Manifest Entries</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExculedManifestEntries()
	 * @generated
	 * @ordered
	 */
	protected EList exculedManifestEntries = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PackagingDetailsImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ProjectPackage.eINSTANCE.getPackagingDetails();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIncrementVersionAutomatically() {
		return incrementVersionAutomatically;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIncrementVersionAutomatically(boolean newIncrementVersionAutomatically) {
		boolean oldIncrementVersionAutomatically = incrementVersionAutomatically;
		incrementVersionAutomatically = newIncrementVersionAutomatically;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PACKAGING_DETAILS__INCREMENT_VERSION_AUTOMATICALLY, oldIncrementVersionAutomatically, incrementVersionAutomatically));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getExculedManifestEntries() {
		if (exculedManifestEntries == null) {
			exculedManifestEntries = new EObjectContainmentEList(Parameter.class, this, ProjectPackage.PACKAGING_DETAILS__EXCULED_MANIFEST_ENTRIES);
		}
		return exculedManifestEntries;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ProjectPackage.PACKAGING_DETAILS__EXCULED_MANIFEST_ENTRIES:
					return ((InternalEList)getExculedManifestEntries()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.PACKAGING_DETAILS__INCREMENT_VERSION_AUTOMATICALLY:
				return isIncrementVersionAutomatically() ? Boolean.TRUE : Boolean.FALSE;
			case ProjectPackage.PACKAGING_DETAILS__EXCULED_MANIFEST_ENTRIES:
				return getExculedManifestEntries();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.PACKAGING_DETAILS__INCREMENT_VERSION_AUTOMATICALLY:
				setIncrementVersionAutomatically(((Boolean)newValue).booleanValue());
				return;
			case ProjectPackage.PACKAGING_DETAILS__EXCULED_MANIFEST_ENTRIES:
				getExculedManifestEntries().clear();
				getExculedManifestEntries().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.PACKAGING_DETAILS__INCREMENT_VERSION_AUTOMATICALLY:
				setIncrementVersionAutomatically(INCREMENT_VERSION_AUTOMATICALLY_EDEFAULT);
				return;
			case ProjectPackage.PACKAGING_DETAILS__EXCULED_MANIFEST_ENTRIES:
				getExculedManifestEntries().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.PACKAGING_DETAILS__INCREMENT_VERSION_AUTOMATICALLY:
				return incrementVersionAutomatically != INCREMENT_VERSION_AUTOMATICALLY_EDEFAULT;
			case ProjectPackage.PACKAGING_DETAILS__EXCULED_MANIFEST_ENTRIES:
				return exculedManifestEntries != null && !exculedManifestEntries.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (incrementVersionAutomatically: ");
		result.append(incrementVersionAutomatically);
		result.append(')');
		return result.toString();
	}

} //PackagingDetailsImpl
