/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.project.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.mtj.api.enumerations.ProjectType;

import org.eclipse.mtj.api.project.ObfuscationDetail;
import org.eclipse.mtj.api.project.PackagingDetails;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.ProjectPackage;
import org.eclipse.mtj.api.project.TargetDevice;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Project</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.project.impl.ProjectImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.ProjectImpl#getTargetDevices <em>Target Devices</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.ProjectImpl#getDefaultTargetDevice <em>Default Target Device</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.ProjectImpl#getObfuscationDetail <em>Obfuscation Detail</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.ProjectImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.ProjectImpl#getPackagingDetails <em>Packaging Details</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.ProjectImpl#getDefaultDeploymentDevice <em>Default Deployment Device</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ProjectImpl extends EObjectImpl implements Project {
	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final ProjectType TYPE_EDEFAULT = ProjectType.PROJECT_TYPE_MIDP_LITERAL;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected ProjectType type = TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getTargetDevices() <em>Target Devices</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTargetDevices()
	 * @generated
	 * @ordered
	 */
	protected EList targetDevices = null;

	/**
	 * The cached value of the '{@link #getDefaultTargetDevice() <em>Default Target Device</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefaultTargetDevice()
	 * @generated
	 * @ordered
	 */
	protected TargetDevice defaultTargetDevice = null;

	/**
	 * The cached value of the '{@link #getObfuscationDetail() <em>Obfuscation Detail</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getObfuscationDetail()
	 * @generated
	 * @ordered
	 */
	protected ObfuscationDetail obfuscationDetail = null;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getPackagingDetails() <em>Packaging Details</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPackagingDetails()
	 * @generated
	 * @ordered
	 */
	protected PackagingDetails packagingDetails = null;

	/**
	 * The cached value of the '{@link #getDefaultDeploymentDevice() <em>Default Deployment Device</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefaultDeploymentDevice()
	 * @generated
	 * @ordered
	 */
	protected TargetDevice defaultDeploymentDevice = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProjectImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ProjectPackage.eINSTANCE.getProject();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProjectType getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(ProjectType newType) {
		ProjectType oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getTargetDevices() {
		if (targetDevices == null) {
			targetDevices = new EObjectContainmentEList(TargetDevice.class, this, ProjectPackage.PROJECT__TARGET_DEVICES);
		}
		return targetDevices;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TargetDevice getDefaultTargetDevice() {
		return defaultTargetDevice;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDefaultTargetDevice(TargetDevice newDefaultTargetDevice, NotificationChain msgs) {
		TargetDevice oldDefaultTargetDevice = defaultTargetDevice;
		defaultTargetDevice = newDefaultTargetDevice;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT__DEFAULT_TARGET_DEVICE, oldDefaultTargetDevice, newDefaultTargetDevice);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDefaultTargetDevice(TargetDevice newDefaultTargetDevice) {
		if (newDefaultTargetDevice != defaultTargetDevice) {
			NotificationChain msgs = null;
			if (defaultTargetDevice != null)
				msgs = ((InternalEObject)defaultTargetDevice).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT__DEFAULT_TARGET_DEVICE, null, msgs);
			if (newDefaultTargetDevice != null)
				msgs = ((InternalEObject)newDefaultTargetDevice).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT__DEFAULT_TARGET_DEVICE, null, msgs);
			msgs = basicSetDefaultTargetDevice(newDefaultTargetDevice, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT__DEFAULT_TARGET_DEVICE, newDefaultTargetDevice, newDefaultTargetDevice));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ObfuscationDetail getObfuscationDetail() {
		return obfuscationDetail;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetObfuscationDetail(ObfuscationDetail newObfuscationDetail, NotificationChain msgs) {
		ObfuscationDetail oldObfuscationDetail = obfuscationDetail;
		obfuscationDetail = newObfuscationDetail;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT__OBFUSCATION_DETAIL, oldObfuscationDetail, newObfuscationDetail);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setObfuscationDetail(ObfuscationDetail newObfuscationDetail) {
		if (newObfuscationDetail != obfuscationDetail) {
			NotificationChain msgs = null;
			if (obfuscationDetail != null)
				msgs = ((InternalEObject)obfuscationDetail).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT__OBFUSCATION_DETAIL, null, msgs);
			if (newObfuscationDetail != null)
				msgs = ((InternalEObject)newObfuscationDetail).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT__OBFUSCATION_DETAIL, null, msgs);
			msgs = basicSetObfuscationDetail(newObfuscationDetail, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT__OBFUSCATION_DETAIL, newObfuscationDetail, newObfuscationDetail));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PackagingDetails getPackagingDetails() {
		return packagingDetails;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPackagingDetails(PackagingDetails newPackagingDetails, NotificationChain msgs) {
		PackagingDetails oldPackagingDetails = packagingDetails;
		packagingDetails = newPackagingDetails;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT__PACKAGING_DETAILS, oldPackagingDetails, newPackagingDetails);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPackagingDetails(PackagingDetails newPackagingDetails) {
		if (newPackagingDetails != packagingDetails) {
			NotificationChain msgs = null;
			if (packagingDetails != null)
				msgs = ((InternalEObject)packagingDetails).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT__PACKAGING_DETAILS, null, msgs);
			if (newPackagingDetails != null)
				msgs = ((InternalEObject)newPackagingDetails).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT__PACKAGING_DETAILS, null, msgs);
			msgs = basicSetPackagingDetails(newPackagingDetails, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT__PACKAGING_DETAILS, newPackagingDetails, newPackagingDetails));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TargetDevice getDefaultDeploymentDevice() {
		if (defaultDeploymentDevice != null && defaultDeploymentDevice.eIsProxy()) {
			TargetDevice oldDefaultDeploymentDevice = defaultDeploymentDevice;
			defaultDeploymentDevice = (TargetDevice)eResolveProxy((InternalEObject)defaultDeploymentDevice);
			if (defaultDeploymentDevice != oldDefaultDeploymentDevice) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ProjectPackage.PROJECT__DEFAULT_DEPLOYMENT_DEVICE, oldDefaultDeploymentDevice, defaultDeploymentDevice));
			}
		}
		return defaultDeploymentDevice;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TargetDevice basicGetDefaultDeploymentDevice() {
		return defaultDeploymentDevice;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDefaultDeploymentDevice(TargetDevice newDefaultDeploymentDevice) {
		TargetDevice oldDefaultDeploymentDevice = defaultDeploymentDevice;
		defaultDeploymentDevice = newDefaultDeploymentDevice;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT__DEFAULT_DEPLOYMENT_DEVICE, oldDefaultDeploymentDevice, defaultDeploymentDevice));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ProjectPackage.PROJECT__TARGET_DEVICES:
					return ((InternalEList)getTargetDevices()).basicRemove(otherEnd, msgs);
				case ProjectPackage.PROJECT__DEFAULT_TARGET_DEVICE:
					return basicSetDefaultTargetDevice(null, msgs);
				case ProjectPackage.PROJECT__OBFUSCATION_DETAIL:
					return basicSetObfuscationDetail(null, msgs);
				case ProjectPackage.PROJECT__PACKAGING_DETAILS:
					return basicSetPackagingDetails(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.PROJECT__TYPE:
				return getType();
			case ProjectPackage.PROJECT__TARGET_DEVICES:
				return getTargetDevices();
			case ProjectPackage.PROJECT__DEFAULT_TARGET_DEVICE:
				return getDefaultTargetDevice();
			case ProjectPackage.PROJECT__OBFUSCATION_DETAIL:
				return getObfuscationDetail();
			case ProjectPackage.PROJECT__NAME:
				return getName();
			case ProjectPackage.PROJECT__PACKAGING_DETAILS:
				return getPackagingDetails();
			case ProjectPackage.PROJECT__DEFAULT_DEPLOYMENT_DEVICE:
				if (resolve) return getDefaultDeploymentDevice();
				return basicGetDefaultDeploymentDevice();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.PROJECT__TYPE:
				setType((ProjectType)newValue);
				return;
			case ProjectPackage.PROJECT__TARGET_DEVICES:
				getTargetDevices().clear();
				getTargetDevices().addAll((Collection)newValue);
				return;
			case ProjectPackage.PROJECT__DEFAULT_TARGET_DEVICE:
				setDefaultTargetDevice((TargetDevice)newValue);
				return;
			case ProjectPackage.PROJECT__OBFUSCATION_DETAIL:
				setObfuscationDetail((ObfuscationDetail)newValue);
				return;
			case ProjectPackage.PROJECT__NAME:
				setName((String)newValue);
				return;
			case ProjectPackage.PROJECT__PACKAGING_DETAILS:
				setPackagingDetails((PackagingDetails)newValue);
				return;
			case ProjectPackage.PROJECT__DEFAULT_DEPLOYMENT_DEVICE:
				setDefaultDeploymentDevice((TargetDevice)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.PROJECT__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case ProjectPackage.PROJECT__TARGET_DEVICES:
				getTargetDevices().clear();
				return;
			case ProjectPackage.PROJECT__DEFAULT_TARGET_DEVICE:
				setDefaultTargetDevice((TargetDevice)null);
				return;
			case ProjectPackage.PROJECT__OBFUSCATION_DETAIL:
				setObfuscationDetail((ObfuscationDetail)null);
				return;
			case ProjectPackage.PROJECT__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ProjectPackage.PROJECT__PACKAGING_DETAILS:
				setPackagingDetails((PackagingDetails)null);
				return;
			case ProjectPackage.PROJECT__DEFAULT_DEPLOYMENT_DEVICE:
				setDefaultDeploymentDevice((TargetDevice)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.PROJECT__TYPE:
				return type != TYPE_EDEFAULT;
			case ProjectPackage.PROJECT__TARGET_DEVICES:
				return targetDevices != null && !targetDevices.isEmpty();
			case ProjectPackage.PROJECT__DEFAULT_TARGET_DEVICE:
				return defaultTargetDevice != null;
			case ProjectPackage.PROJECT__OBFUSCATION_DETAIL:
				return obfuscationDetail != null;
			case ProjectPackage.PROJECT__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ProjectPackage.PROJECT__PACKAGING_DETAILS:
				return packagingDetails != null;
			case ProjectPackage.PROJECT__DEFAULT_DEPLOYMENT_DEVICE:
				return defaultDeploymentDevice != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (type: ");
		result.append(type);
		result.append(", name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //ProjectImpl
