/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.runtimes;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage
 * @generated
 */
public interface RuntimesFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	RuntimesFactory eINSTANCE = new org.eclipse.mtj.api.runtimes.impl.RuntimesFactoryImpl();

	/**
	 * Returns a new object of class '<em>Runtime Platform Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runtime Platform Definition</em>'.
	 * @generated
	 */
	RuntimePlatformDefinition createRuntimePlatformDefinition();

	/**
	 * Returns a new object of class '<em>Device Profile</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Device Profile</em>'.
	 * @generated
	 */
	DeviceProfile createDeviceProfile();

	/**
	 * Returns a new object of class '<em>Service Api</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Service Api</em>'.
	 * @generated
	 */
	ServiceApi createServiceApi();

	/**
	 * Returns a new object of class '<em>Device Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Device Configuration</em>'.
	 * @generated
	 */
	DeviceConfiguration createDeviceConfiguration();

	/**
	 * Returns a new object of class '<em>Implementation Ref</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Implementation Ref</em>'.
	 * @generated
	 */
	ImplementationRef createImplementationRef();

	/**
	 * Returns a new object of class '<em>Jvm Implementation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Jvm Implementation</em>'.
	 * @generated
	 */
	JvmImplementation createJvmImplementation();

	/**
	 * Returns a new object of class '<em>Runtime Platform</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runtime Platform</em>'.
	 * @generated
	 */
	RuntimePlatform createRuntimePlatform();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	RuntimesPackage getRuntimesPackage();

} //RuntimesFactory
