/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.signings.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.mtj.api.signings.SigningCertificate;
import org.eclipse.mtj.api.signings.SigningsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Signing Certificate</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.signings.impl.SigningCertificateImpl#getKeystore <em>Keystore</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.signings.impl.SigningCertificateImpl#getAliasName <em>Alias Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.signings.impl.SigningCertificateImpl#getKeystorePassword <em>Keystore Password</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.signings.impl.SigningCertificateImpl#getCertificatePassword <em>Certificate Password</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SigningCertificateImpl extends EObjectImpl implements SigningCertificate {
	/**
	 * The default value of the '{@link #getKeystore() <em>Keystore</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeystore()
	 * @generated
	 * @ordered
	 */
	protected static final String KEYSTORE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getKeystore() <em>Keystore</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeystore()
	 * @generated
	 * @ordered
	 */
	protected String keystore = KEYSTORE_EDEFAULT;

	/**
	 * The default value of the '{@link #getAliasName() <em>Alias Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAliasName()
	 * @generated
	 * @ordered
	 */
	protected static final String ALIAS_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAliasName() <em>Alias Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAliasName()
	 * @generated
	 * @ordered
	 */
	protected String aliasName = ALIAS_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getKeystorePassword() <em>Keystore Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeystorePassword()
	 * @generated
	 * @ordered
	 */
	protected static final String KEYSTORE_PASSWORD_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getKeystorePassword() <em>Keystore Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeystorePassword()
	 * @generated
	 * @ordered
	 */
	protected String keystorePassword = KEYSTORE_PASSWORD_EDEFAULT;

	/**
	 * The default value of the '{@link #getCertificatePassword() <em>Certificate Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCertificatePassword()
	 * @generated
	 * @ordered
	 */
	protected static final String CERTIFICATE_PASSWORD_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCertificatePassword() <em>Certificate Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCertificatePassword()
	 * @generated
	 * @ordered
	 */
	protected String certificatePassword = CERTIFICATE_PASSWORD_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SigningCertificateImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return SigningsPackage.eINSTANCE.getSigningCertificate();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getKeystore() {
		return keystore;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setKeystore(String newKeystore) {
		String oldKeystore = keystore;
		keystore = newKeystore;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SigningsPackage.SIGNING_CERTIFICATE__KEYSTORE, oldKeystore, keystore));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAliasName() {
		return aliasName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAliasName(String newAliasName) {
		String oldAliasName = aliasName;
		aliasName = newAliasName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SigningsPackage.SIGNING_CERTIFICATE__ALIAS_NAME, oldAliasName, aliasName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getKeystorePassword() {
		return keystorePassword;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setKeystorePassword(String newKeystorePassword) {
		String oldKeystorePassword = keystorePassword;
		keystorePassword = newKeystorePassword;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SigningsPackage.SIGNING_CERTIFICATE__KEYSTORE_PASSWORD, oldKeystorePassword, keystorePassword));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getCertificatePassword() {
		return certificatePassword;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCertificatePassword(String newCertificatePassword) {
		String oldCertificatePassword = certificatePassword;
		certificatePassword = newCertificatePassword;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SigningsPackage.SIGNING_CERTIFICATE__CERTIFICATE_PASSWORD, oldCertificatePassword, certificatePassword));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SigningsPackage.SIGNING_CERTIFICATE__KEYSTORE:
				return getKeystore();
			case SigningsPackage.SIGNING_CERTIFICATE__ALIAS_NAME:
				return getAliasName();
			case SigningsPackage.SIGNING_CERTIFICATE__KEYSTORE_PASSWORD:
				return getKeystorePassword();
			case SigningsPackage.SIGNING_CERTIFICATE__CERTIFICATE_PASSWORD:
				return getCertificatePassword();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SigningsPackage.SIGNING_CERTIFICATE__KEYSTORE:
				setKeystore((String)newValue);
				return;
			case SigningsPackage.SIGNING_CERTIFICATE__ALIAS_NAME:
				setAliasName((String)newValue);
				return;
			case SigningsPackage.SIGNING_CERTIFICATE__KEYSTORE_PASSWORD:
				setKeystorePassword((String)newValue);
				return;
			case SigningsPackage.SIGNING_CERTIFICATE__CERTIFICATE_PASSWORD:
				setCertificatePassword((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SigningsPackage.SIGNING_CERTIFICATE__KEYSTORE:
				setKeystore(KEYSTORE_EDEFAULT);
				return;
			case SigningsPackage.SIGNING_CERTIFICATE__ALIAS_NAME:
				setAliasName(ALIAS_NAME_EDEFAULT);
				return;
			case SigningsPackage.SIGNING_CERTIFICATE__KEYSTORE_PASSWORD:
				setKeystorePassword(KEYSTORE_PASSWORD_EDEFAULT);
				return;
			case SigningsPackage.SIGNING_CERTIFICATE__CERTIFICATE_PASSWORD:
				setCertificatePassword(CERTIFICATE_PASSWORD_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SigningsPackage.SIGNING_CERTIFICATE__KEYSTORE:
				return KEYSTORE_EDEFAULT == null ? keystore != null : !KEYSTORE_EDEFAULT.equals(keystore);
			case SigningsPackage.SIGNING_CERTIFICATE__ALIAS_NAME:
				return ALIAS_NAME_EDEFAULT == null ? aliasName != null : !ALIAS_NAME_EDEFAULT.equals(aliasName);
			case SigningsPackage.SIGNING_CERTIFICATE__KEYSTORE_PASSWORD:
				return KEYSTORE_PASSWORD_EDEFAULT == null ? keystorePassword != null : !KEYSTORE_PASSWORD_EDEFAULT.equals(keystorePassword);
			case SigningsPackage.SIGNING_CERTIFICATE__CERTIFICATE_PASSWORD:
				return CERTIFICATE_PASSWORD_EDEFAULT == null ? certificatePassword != null : !CERTIFICATE_PASSWORD_EDEFAULT.equals(certificatePassword);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (keystore: ");
		result.append(keystore);
		result.append(", aliasName: ");
		result.append(aliasName);
		result.append(", keystorePassword: ");
		result.append(keystorePassword);
		result.append(", certificatePassword: ");
		result.append(certificatePassword);
		result.append(')');
		return result.toString();
	}

} //SigningCertificateImpl
