/*******************************************************************************
* Copyright (c) 2005, 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.core.ui.model;

import java.util.Hashtable;

// Todo: Will probably remove modifiedmap
public class ProjectCreationModel {

	protected Hashtable properties;

	public ProjectCreationModel() {
		properties = new Hashtable();
	}

	public Object getProperty(String key) {

		return properties.get(key);
	}

	public void setProperty(String key, Object value) {
		properties.put(key, value);
	}

	/**
	 * Return if the Map has a value defined for a key.  The empty string is not considered a value.
	 * @param key
	 * @return
	 */
	public boolean hasProperty(String key) {
		if (properties.get(key) != null && !properties.get(key).equals("")) { //$NON-NLS-1$
			return true;
		}
		return false;
	}
	
	/**
	 * Return if the Map has a value defined for a key.  The empty string is  considered a value.
	 * @param key
	 * @return
	 */
	public boolean hasPropertyValue(String key) {
		if (properties.get(key) != null) { 
			return true;
		}
		return false;
	}
}
