/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.preferences.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.mtj.api.extension.AdminGuiProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.mtj.core.ui.preferences.model.ExtensionContentProvider;
import org.eclipse.mtj.core.ui.preferences.model.ExtensionImplNode;
import org.eclipse.mtj.core.ui.preferences.model.ExtensionLabelProvider;
import org.eclipse.mtj.core.ui.preferences.view.ExtensionInfoDialog;
import org.eclipse.mtj.core.ui.preferences.view.MTJManagerViewUI;
import org.eclipse.mtj.core.ui.preferences.view.ProjectScopeDialog;
import org.eclipse.mtj.core.ui.util.GridUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;


public class ManagerPrefPage extends PreferencePage implements MouseListener, SelectionListener {

	public static final String PREF_ID= "org.eclipse.mtj.core.ui.preferences.control.MtjProjectPreferencePage";  //$NON-NLS-1$
	//"org.eclipse.mtj.extension.rpm.ui.preferences.ProjectRuntimeMgmtPreferencePage";
	//"org.eclipse.mtj.core.ui.preferences.control.MtjProjectPreferencePage"; //$NON-NLS-1$
	public static final String PROP_ID= "org.eclipse.mtj.extension.rpm.ui.preferences.ProjectRuntimeMgmtPreferencePage";  //$NON-NLS-1$
	//"org.eclipse.mtj.core.ui.properties.control.MtjProjectPreferencePage"; //$NON-NLS-1$
	
	public static final String PLUGIN_ID = "org.eclipse.mtj.extension.devide"; //$NON-NLS-1$

	public static final String MTJ_NATURE_ID = PLUGIN_ID + ".nature"; //$NON-NLS-1$
	
	/**
	 * This class is showing the actual UI, 
	 * over here it's modelled as the view   
	 */
	private MTJManagerViewUI mtjManagerViewUI;	
	
	protected static String srvFrwFilter = "MANAGEMENT"; //$NON-NLS-1$

	
	//                                          Name     Vendor    Version
	private final static String[] COLUMNS = { "STRING", "STRING", "STRING" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	
	private int row_index = 0;
	/**
	 * 
	 */
	private ArrayList listeners = new ArrayList(2);
	
	private IProject fProject; // project or null
	
	private IJavaProject[] selectedProjects = null; 
	
	public static final String DATA_NO_LINK= "PropertyAndPreferencePage.nolink"; //$NON-NLS-1$
	
	
	private Composite _composite = null;
	
	/**
	 * 
	 */
	public ManagerPrefPage(IPreferenceStore preferenceStore) {
		super();
	}
	/**
	 * @param title
	 */
	public ManagerPrefPage(String title) {
		super(title);
	}

	/**
	 * @param title
	 * @param image
	 */
	public ManagerPrefPage(String title, ImageDescriptor image) {
		super(title, image);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(org.eclipse.swt.widgets.Composite)
	 */
	public Control createContents(Composite parent) {
		_composite = new Composite(parent, SWT.NONE);
		
        Link lnkProjectSettings = new Link(_composite, SWT.NONE);
        GridData gd = new GridData(GridData.HORIZONTAL_ALIGN_END);
        lnkProjectSettings.setLayoutData(gd);
        lnkProjectSettings.setText(Messages.ManagerPrefPage_ConfigureMtjProjectSettings);
        lnkProjectSettings.setToolTipText(Messages.ManagerPrefPage_ConfigureMtjProjectSpecificSettingsToolTip);

        lnkProjectSettings.addSelectionListener(new SelectionListener() {
            public void widgetSelected(SelectionEvent e) {
				doLinkActivated((Link) e.widget);
			}

			public void widgetDefaultSelected(SelectionEvent e) {
				doLinkActivated((Link) e.widget);
			}
        });
        
        //Group grpProviders = new Group(composite, SWT.NONE);
        //grpProviders.setText("Frameworks"); 
        
		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		_composite.setLayout(layout);
		GridData data = GridUtil.createFill();
		_composite.setLayoutData(data);

		mtjManagerViewUI = new MTJManagerViewUI(COLUMNS);
		mtjManagerViewUI.createControl(_composite);
		
		createControl(_composite);
		
		initializeDefaults();
		
		PlatformUI.getWorkbench().getHelpSystem().setHelp(_composite, MtjCoreUiPlugin.getPluginId()+".mtjcore0002");		 //$NON-NLS-1$
		return _composite;

	}

	public void createControl(Composite parent) {

		//createControl(composite);
		mtjManagerViewUI.getTableViewer().setContentProvider(new ExtensionContentProvider());
		mtjManagerViewUI.getTableViewer().setLabelProvider(new ExtensionLabelProvider());
		
		mtjManagerViewUI.get_tableList().addSelectionListener(this);
		mtjManagerViewUI.get_tableList().addMouseListener(this);
		mtjManagerViewUI.get_tableList().addSelectionListener(this);
		mtjManagerViewUI.get_moveUp().addSelectionListener(this);
		mtjManagerViewUI.get_moveDown().addSelectionListener(this);
		mtjManagerViewUI.get_selAll().addSelectionListener(this);
		mtjManagerViewUI.get_unselAll().addSelectionListener(this);
		mtjManagerViewUI.get_showDetail().addSelectionListener(this);
		
		/*
		ExtensionCellModifier extensionCellModifier = new ExtensionCellModifier(mtjManagerViewUI.getTableViewer());
		
		final CellEditor[] editors = new CellEditor[2];
	    TextCellEditor editor = new TextCellEditor(mtjManagerViewUI.get_tableList());
	    editor.activate();
	    editors[1] = editor;

	    mtjManagerViewUI.getTableViewer().setCellEditors(editors);
	    mtjManagerViewUI.getTableViewer().setCellModifier(new ExtensionCellModifier(mtjManagerViewUI.getTableViewer()));
	    //mtjManagerViewUI.getTableViewer().getCellModifier();
		*/
		TableViewerSorter.setTableSorter(mtjManagerViewUI.getTableViewer(), 0, true);
		
		mtjManagerViewUI.getTableViewer().getTable().addListener(SWT.Selection, new Listener() {
		      public void handleEvent(Event event) {
		        TableItem _item = (TableItem)event.item;
		        ExtensionImplNode _cd = (ExtensionImplNode)_item.getData();
		        MtjExtension _m = null;
		        row_index = mtjManagerViewUI.getTableViewer().getTable().getSelectionIndex();
		        if (_item.getChecked()) {		        	
		        	if (_cd.getImpl() instanceof MtjExtension){
			        	_m = (MtjExtension)_cd.getImpl();
			        	_m.setActive(true);
			        	_cd.setActive(Boolean.TRUE.toString());
		        	}	
		        }		        	
		        else{
		        	if (_cd.getImpl() instanceof MtjExtension){
			        	_m = (MtjExtension)_cd.getImpl();
			        	_m.setActive(false);
			        	_cd.setActive(Boolean.FALSE.toString());
		        	}	
		        }
		        try {
		        	AdminGuiProvider adminGuiProvider = MtjServices.getInstance().getCorrespondingAdminGuiProvider(_m);
		        	if (adminGuiProvider == null) {
		        		mtjManagerViewUI.get_showDetail().setEnabled(false);
		        	}else {
		        		mtjManagerViewUI.get_showDetail().setEnabled(true);
		        	}
				} catch (MtjException ex) {
		    		MtjCoreUiPlugin.getDefault().displayError(getShell(),1,1,Messages.ManagerPrefPage_Error,"AdminGuiProvider.create",ex );  //$NON-NLS-1$
		    		//MtjCoreUiPlugin.getDefault().getBundle().
		    		ex.printStackTrace();
				}

		        mtjManagerViewUI.getTableViewer().getTable().redraw();
		      }
		    }
		);
		mtjManagerViewUI.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				Object o = ((IStructuredSelection)mtjManagerViewUI.getTableViewer().getSelection()).getFirstElement();
				int size = mtjManagerViewUI.getTableViewer().getTable().getItemCount();
				if( o == mtjManagerViewUI.getTableViewer().getElementAt(0)) {
					mtjManagerViewUI.get_moveUp().setEnabled(false);
					mtjManagerViewUI.get_moveDown().setEnabled(true);
				} else if( o == mtjManagerViewUI.getTableViewer().getElementAt(size-1)) {
					mtjManagerViewUI.get_moveDown().setEnabled(false);
					mtjManagerViewUI.get_moveUp().setEnabled(true);
				} else {
					mtjManagerViewUI.get_moveDown().setEnabled(true);
					mtjManagerViewUI.get_moveUp().setEnabled(true);
				}
			} 
			} 
		);

		mtjManagerViewUI.getTableViewer().setInput(parent);
		mtjManagerViewUI.getTableViewer().refresh();
	}
	

	final void doLinkActivated(Link link) {
		Map data= new HashMap();
		data.put(DATA_NO_LINK, Boolean.TRUE);
		IJavaProject[] projects = null;
		
		if (isProjectPreferencePage()) {
			openWorkspacePreferences(data);
		} else {
			HashSet projectsWithSpecifics= new HashSet();
			try {
				projects = JavaCore.create(ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
				for (int i= 0; i < projects.length; i++) {
					IJavaProject curr= projects[i];
					if (hasProjectSpecificOptions(curr.getProject())) {
						projectsWithSpecifics.add(curr);
					}
				}
			} catch (JavaModelException e) {
				// ignore
			} catch ( CoreException ex) {
				MtjCoreUiPlugin.displayError(MtjCorePlugin.getDefault().getActiveShell(),1,1,Messages.ManagerPrefPage_Error,Messages.ManagerPrefPage_ErrorOccurred, ex);							
			}
			try {
				ProjectScopeDialog _dialog = new ProjectScopeDialog(MtjCorePlugin.getDefault().getActiveShell(), Messages.ManagerPrefPage_SelectMTJProjects, projectsWithSpecifics, projects);

				if (_dialog.open() == Window.OK) {
					IJavaProject[] _selectedProjects = _dialog.getSelectionResult();
					
					setSelectedProjects(null);				
					//	Save selected projects to later usage
					setSelectedProjects(_selectedProjects);
					for (int i= 0; i < _selectedProjects.length; i++) {
						IJavaProject res = _selectedProjects[i];
					
						//System.out.println( ((IProject)res.getProject()).getName());
						//openProjectProperties(res.getProject(), data);
					}
				}
			} catch ( Exception ex) {
				MtjCoreUiPlugin.displayError(MtjCorePlugin.getDefault().getActiveShell(),1,1,Messages.ManagerPrefPage_Error,Messages.ManagerPrefPage_ErrorOccurred, ex);							
			}				
		}
	}
	protected boolean isProjectPreferencePage() {
		return fProject != null;
	}
	
	protected final void openWorkspacePreferences(Object data) {
		String id= getPreferencePageID();
		PreferencesUtil.createPreferenceDialogOn(getShell(), id, new String[] { id }, data).open();
	}
	protected final void openProjectProperties(IProject project, Object data) {
		String id= getPropertyPageID();
		if (id != null) {
			PreferencesUtil.createPropertyDialogOn(getShell(), project, id, new String[] { id }, data).open();
		}
	}	
	

	
	/* 
	 * 
	 */
	private String getPreferencePageID() {
		return PREF_ID;
	}

	/* 
	 * 
	 */
	protected String getPropertyPageID() {
		return PROP_ID;
	}
	
	/* 
	 * hasProjectSpecificOptions -method
	 * Checks that are there any MTJ nature id's in the project
	 *
	 * @param project IProject
	 * @return boolean indicating the success
	 * @throws CoreException
	 */
	protected boolean hasProjectSpecificOptions(IProject project) throws CoreException {
		IProjectDescription description = project.getDescription();
		String[] natures = description.getNatureIds();
		for (int i = 0; i < natures.length; ++i) {
			if (getNatureID().equals(natures[i])) {
				// MTJ Nature found
				return true;
			}
		}
		//No MTJ nature found
		return false;
	}
	/**
	 * Return a boolean indicating whether the specified project has the J2ME
	 * nature associated with it.
	 * 
	 * @param project the project to be tested for the J2ME nature
	 * @return a boolean indicating whether the specified project has
	 * the J2ME nature
	 * @throws CoreException
	 */
	public static boolean hasMtjNature(IProject project)
		throws CoreException
	{
		return project.hasNature(MTJ_NATURE_ID);
	}
	public static String getNatureID ()
	{
		return MTJ_NATURE_ID;
	}
	//---------------------------------------------------------------------
	
	
	/**
	 * init -method
	 * 
	 * @param workbench
	 */
	public void init(IWorkbench workbench) {
	}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {
		initializeValues(true);
	}
	/**
	 * Initializes states of the controls from the preference store.
	 * Over here the filter is set for the service content provider
	 * 
	 */
	private void initializeValues(boolean _startUpDone) {
		if (_startUpDone){
			//filter
			mtjManagerViewUI.getTableViewer().addFilter(new ViewerFilter() {
				public boolean select(Viewer viewer, Object parentElement, Object element) {
					ExtensionImplNode _cd = (ExtensionImplNode)element;
					return ( _cd.getName().toUpperCase().endsWith(srvFrwFilter) ) ;
				}
			});
		}	
		if (mtjManagerViewUI.getTableViewer().getTable().getItemCount() > 0) {
			mtjManagerViewUI.getTableViewer().getTable().select(0);
			mtjManagerViewUI.get_moveDown().setEnabled(true);
		}
		
 		for (int idx = 0; idx < mtjManagerViewUI.getTableViewer().getTable().getItemCount(); idx++) {		
			try {
				TableItem _item = mtjManagerViewUI.getTableViewer().getTable().getItem(idx);
				ExtensionImplNode _cd = (ExtensionImplNode)_item.getData();
				MtjExtension _m = null;
				if (_cd.getImpl() instanceof MtjExtension){
					_m = (MtjExtension)_cd.getImpl();
					_item.setChecked(_m.isActive());
				}
			} catch (Exception ex) {
				MtjCoreUiPlugin.displayError(MtjCorePlugin.getDefault().getActiveShell(),1,1,Messages.ManagerPrefPage_Error,Messages.ManagerPrefPage_ErrorOccurred, ex);				
			}
		}	

	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	public void performDefaults() {
		initializeDefaults();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#applyData(java.lang.Object)
	 */
	@Override
	public void applyData(Object data) {
		StatusUtil.applyToStatusLine(this, new StatusInfo(IStatus.OK, "applyData()")); //$NON-NLS-1$
		super.applyData(data);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#okToLeave()
	 */
	@Override
	public boolean okToLeave() {
		StatusUtil.applyToStatusLine(this, new StatusInfo(IStatus.OK, "okToLeave()")); //$NON-NLS-1$
		return super.okToLeave();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#performApply()
	 */
	@Override
	public void performApply() {
		StatusUtil.applyToStatusLine(this, new StatusInfo(IStatus.OK, "performApply()")); //$NON-NLS-1$
		storeValues();
		super.performApply();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#performCancel()
	 */
	@Override
	public boolean performCancel() {
		StatusUtil.applyToStatusLine(this, new StatusInfo(IStatus.OK, "performCancel()")); //$NON-NLS-1$
		return super.performCancel();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#performHelp()
	 */
	@Override
	public void performHelp() {
		StatusUtil.applyToStatusLine(this, new StatusInfo(IStatus.OK, "performHelp()")); //$NON-NLS-1$
		super.performHelp();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#performOk()
	 */
	@Override
	public boolean performOk() {
		StatusUtil.applyToStatusLine(this, new StatusInfo(IStatus.OK, "performOk()")); //$NON-NLS-1$
		
		storeValues();
		
		return super.performOk();
	}
		
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.MouseListener#mouseDoubleClick(org.eclipse.swt.events.MouseEvent)
	 */
	public void mouseDoubleClick(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.MouseListener#mouseDown(org.eclipse.swt.events.MouseEvent)
	 */
	public void mouseDown(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.MouseListener#mouseUp(org.eclipse.swt.events.MouseEvent)
	 */
	public void mouseUp(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
		
	}
	/** 
	 * getSelectedProjects -method
	 * 
	 * @return selected MTJ projects
	 */	
	private IJavaProject[] getSelectedProjects() {
		if (selectedProjects.length >0 ){
			return selectedProjects;
		} else {
			return null;
		}	
	}
	/**
	 * setSelectedProjects -method
	 * Sets the selected MTJ projects to internal variable 
	 * @param _prj
	 */
	protected void setSelectedProjects(IJavaProject[] _prj){
		selectedProjects = _prj;
	}	
	/**
	 * storeValues -method
	 * 
	 * Stores the changes preference values to the preferences
	 * 
	 */
	public void storeValues() {

		boolean _hasProjectScope = false;
 
		if ( selectedProjects != null && selectedProjects.length >0)
			_hasProjectScope = true;
		
		TableItem[] items = mtjManagerViewUI.getTableViewer().getTable().getItems();
    	for (int i = 0; i < items.length; i++) {
			ExtensionImplNode _cd = (ExtensionImplNode)items[i].getData();
    		if ( _cd.getImpl() != null && _cd.getImpl() instanceof MtjExtension ) {
    			MtjExtension mtjE = (MtjExtension)_cd.getImpl();
    			try {
    				// We loop through the selected projects and set MtjService activity based on that
    				if (_hasProjectScope ){    					
    					for (int ix = 0; ix < selectedProjects.length; ix++ ){
    						IProject _prj = (IProject) ((IJavaProject)selectedProjects[ix]).getProject();
    						MtjServices.getInstance().setActive(mtjE.getId(), mtjE.getType(),_prj.getName(), items[i].getChecked());
    					}	
    				} else {
    					MtjServices.getInstance().setActive(mtjE.getId(), mtjE.getType(),items[i].getChecked());
    				}	
    			} catch ( MtjException mtjEx ) {
    				MtjCoreUiPlugin.displayError(MtjCorePlugin.getDefault().getActiveShell(),1,1,Messages.ManagerPrefPage_Error,Messages.ManagerPrefPage_ErrorOccurred, mtjEx);
    				
    			}
    		}
    	}

	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
		notifyListeners(e);

		if (e.widget == mtjManagerViewUI.get_moveUp()) {
			
			int idx = mtjManagerViewUI.get_tableList().getSelectionIndex();
			if (idx > 0)
				row_index = idx;
			
			moveUp(idx, mtjManagerViewUI.get_tableList());
			
		} else if (e.widget == mtjManagerViewUI.get_moveDown()) {
			int idx = mtjManagerViewUI.get_tableList().getSelectionIndex();

			if (idx != -1 && (idx < mtjManagerViewUI.get_tableList().getItemCount() - 1))
				row_index = idx;
				moveDown(idx, mtjManagerViewUI.get_tableList());
				
		} else if (e.widget == mtjManagerViewUI.get_selAll()) {
			for (int idx = 0; idx < mtjManagerViewUI.get_tableList().getItemCount(); idx++) {
				TableItem item = mtjManagerViewUI.get_tableList().getItem(idx);
				item.setChecked(true);

				ExtensionImplNode _cd = (ExtensionImplNode)item.getData();
		        
				MtjExtension _m = null;
		        if (_cd.getImpl() instanceof MtjExtension){
			       	_m = (MtjExtension)_cd.getImpl();
			       	_m.setActive(true);
			       	item.setChecked(true);
		        }
			
			}
			return;
			
		} else if (e.widget == mtjManagerViewUI.get_unselAll()) {
			for (int idx = 0; idx < mtjManagerViewUI.get_tableList().getItemCount(); idx++) {
				TableItem item = mtjManagerViewUI.get_tableList().getItem(idx);
				item.setChecked(false);

				ExtensionImplNode _cd = (ExtensionImplNode)item.getData();
		        MtjExtension _m = null;
		        if (_cd.getImpl() instanceof MtjExtension){
			       	_m = (MtjExtension)_cd.getImpl();
			       	_m.setActive(false);
		        }
   	
			}					
			return;
			
		} else if (e.widget == mtjManagerViewUI.get_showDetail()) {

			ExtensionImplNode _colData = (ExtensionImplNode)mtjManagerViewUI.get_tableList().getItem(row_index).getData();
			MtjExtension _m = null;
			ExtensionInfoDialog dlg = null;
			
	        if (_colData.getImpl() instanceof MtjExtension){
		       	_m = (MtjExtension)_colData.getImpl();
				  	
		       	dlg = new ExtensionInfoDialog( MtjCorePlugin.getDefault().getActiveShell(), "", _m); //$NON-NLS-1$
		       	dlg.createContent(_composite);
		       	if (dlg.hasAdminGui()) {
		       		dlg.open();
		       	}
			}
		       	
		}
		/*
		*/
		int idx = mtjManagerViewUI.get_tableList().getSelectionIndex();

		ExtensionImplNode data = null;
		ExtensionImplNode previousData = null;
		if (idx > 0) {
			row_index = idx;
			previousData = (ExtensionImplNode) mtjManagerViewUI.get_tableList().getItem(idx - 1).getData();
		}
		if (idx != -1) {
			row_index = idx;
			data = (ExtensionImplNode) mtjManagerViewUI.get_tableList().getItem(idx).getData();
		}

		mtjManagerViewUI.get_moveUp().setEnabled(data != null && previousData != null);
		mtjManagerViewUI.get_moveDown().setEnabled(data != null && (idx < mtjManagerViewUI.get_tableList().getItemCount() - 1));
		
		
	}
	public void addListener(SelectionListener listener){
		if(!listeners.contains(listener)){
			listeners.add(listener);		
		}
	}
	
	public void removeListener(SelectionListener listener){
		listeners.remove(listener);
	}
	
	/**
	 * @param e
	 */
	public void notifyListeners(SelectionEvent e){
		for(int i=0;i<listeners.size();i++){
			((SelectionListener)listeners.get(i)).widgetSelected(e);
		}
	}
	public int getSelectedRow_Index(){
		return row_index;
	}
	/**
	 * @param idx
	 * @param _list
	 */
	protected void moveDown(int idx, Table _list) {
		//TableItem item = _list.getItem(idx);
		//ExtensionImplNode data = (ExtensionImplNode) item.getData();

		mtjManagerViewUI.getTableViewer().getTable().deselect(idx);
		mtjManagerViewUI.getTableViewer().getTable().select(idx + 1);
		row_index = idx + 1;

	}
	protected void moveUp(int idx, Table _list) {
		//TableItem item = _list.getItem(idx);
		//ExtensionImplNode data = (ExtensionImplNode) item.getData();

		mtjManagerViewUI.getTableViewer().getTable().deselect(idx);
		mtjManagerViewUI.getTableViewer().getTable().select(idx - 1);
		row_index = idx -1;
		
	}
	private class ExtensionCellModifier implements ICellModifier {
		private Viewer viewer;

		public ExtensionCellModifier(Viewer viewer) {
			this.viewer = viewer;
		}
		/**
		 * @see ICellModifier#canModify(Object, String)
		 */
		public boolean canModify(Object element, String property) {
			
			if (element instanceof ExtensionImplNode) {
				ExtensionImplNode myTableElement = (ExtensionImplNode) element;
				if (property.equals(COLUMNS[0]))
					return true;

				if (property.equals(COLUMNS[1]))
					return true;
				
				if (property.equals(COLUMNS[2]))
					return true;
				
				
			}
			return false;
		}
		/**
		 * @see ICellModifier#getValue(Object, String)
		 */
		public Object getValue(Object element, String property) {
		
			if (element instanceof ExtensionImplNode) {
				ExtensionImplNode myTableElement = (ExtensionImplNode) element;

				if (property.equals(COLUMNS[0]))
					return myTableElement.getName();

				if (property.equals(COLUMNS[1]))
					return myTableElement.getVendor();

				if (property.equals(COLUMNS[2]))
					return myTableElement.getVersion();
				
			
			}
			return null;
		}
		/**
		 * @see ICellModifier#modify(Object, String, Object)
		 */
		public void modify(Object element, String property, Object value) {
			if (element instanceof TableItem) {
				Object myElement = ((TableItem) element).getData();

				if (myElement instanceof ExtensionImplNode) {
					ExtensionImplNode myTableElement = (ExtensionImplNode) myElement;

					if (property.equals(COLUMNS[0]))
						myTableElement.setName((String) value);

					viewer.refresh();
				}
			}
		}
		private Integer getValueIndex(String value) {
			return new Integer(0);
		}
		private String getValue(Integer index) {
			return null;
		}
	}
	
}
