/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;

public class ColumnData {

	
	private String _name;
	private boolean _visible = false;
	private Object _obj;
	/**
	 * 
	 */
	public ColumnData() {
		super();
		// TODO Auto-generated constructor stub
	}
	/**
	 * A constructor for ColumnData.java
	 * @param name
	 * @param visible
	 */
	public ColumnData(String name, boolean visible) {
		_name = name;
		_visible = visible;
	}
	/**
	 * A constructor for ColumnData.java
	 * @param name
	 * @param visible
	 * @param obj
	 */
	public ColumnData(String name, boolean visible, Object obj) {
		_name = name;
		_visible = visible;
		_obj = obj;
	}
	
	/**
     * createColumnData creates an ArrayList of ColumnData information from
     * the data stored in the preferences store.
     * The data in the preferences store is stored as a series of column definitions
     * separated by commas.  For a description of an individual column definition, see
     * addColumnData.
     * @param String the key to extract the column definition string from the preferences
     * store.
     */
	public static ArrayList createColumnData(String preferenceKey, String defaultColumns) {
		
		String preferenceColumns = MtjCoreUiPlugin.getDefault().getPreferenceStore().getString(preferenceKey);
		
		if (preferenceColumns == null || preferenceColumns.length() == 0) {
			preferenceColumns = defaultColumns;
		}
	    return createColumnDataFromString(preferenceColumns);
	}
	
	/**
	 * @param preferenceColumns
	 * @return
	 */
	public static ArrayList createColumnDataFromString(String preferenceColumns) {
		
		ArrayList columnDataList=null;
			
		if (preferenceColumns != null && !preferenceColumns.equals("")) { //$NON-NLS-1$
			
			// Walk the data and count how many columns the table should have
			// and then allocate the column ArrayList using that size.			
			int count = 1;
			String _break = "|"; //$NON-NLS-1$
			
			for (int i = 0; i <preferenceColumns.length();i++) {
				char c = preferenceColumns.charAt(i);
				if ( _break.indexOf(c)!= -1 )
					count++;
			}
			
			columnDataList = new ArrayList(count);
			
			// Walk the data again parsing each column data template and adding it
			// to the column data array list.
			int idx = 0;
			String columnDataTemplate;
			while (idx != -1) {
				idx = preferenceColumns.indexOf("|"); //$NON-NLS-1$
				
				if (idx != -1) {
					// For all but the last column definition
					columnDataTemplate = preferenceColumns.substring(0, idx);
					preferenceColumns = preferenceColumns.substring(idx + 1);
				}
				else {
					// For the last column definition.
					columnDataTemplate = preferenceColumns;
				}
				columnDataList = addColumnData(columnDataTemplate, columnDataList);
			}
		}
		
		return columnDataList;
	}
	/**
	 * addColumnData parses a single column definition and adds the defintion
	 * to the ColumnData array list.
	 * @param column java.lang.String containing the column template information
	 * The column template consists of the column name followed by a : followed by the
	 * visiblity flag true or false, followed by a :
	 * @param ArrayList containing the ColumnData created from the template
	 */
	private static ArrayList addColumnData(String columnTemplate, ArrayList _list) {

		String columnName = ""; //$NON-NLS-1$
		boolean visible = false;
		
		// Parse off the column name.
		int idx = columnTemplate.indexOf("="); //$NON-NLS-1$
		if (idx != -1) {
			columnName = columnTemplate.substring(0, idx);
			columnTemplate = columnTemplate.substring(idx + 1);
		}
		else
		   columnName = columnTemplate;
		   
		if(columnTemplate.equals("1")){ //$NON-NLS-1$
			visible = true;		
		}else{
			visible = false;
		}
		
		//
		ColumnData _colData = new ColumnData(columnName, visible);
		_list.add( _colData );
		return _list;
	}
	/**
	 * setColumns saves a new set of ColumnData from the newList to the currentList and
	 * then serializes the data and persists it to the preferences store.
	 *
	 * @param java.util.ArrayList newList is the new ColumnData information
	 * @param java.util.ArrayList currentList is the current ColumnData information
	 * @param java.lang.String preferenceKey is the key to store the serialized data in the
	 * preferences store.
	 */
	public static void setColumns(List newList, List currentList, String preferenceKey, IPreferenceStore store) {
		// Replace the current list data with the new list data
		currentList.clear();
		currentList.addAll(newList);
		setColumns(currentList, preferenceKey, store);
	}
	
	/**
	 * @param currentList
	 * @param preferenceKey
	 * @param store
	 */
	public static void setColumns(List currentList, String preferenceKey, IPreferenceStore store) {
		
		// Create the column data template string to save in the preferences store
		String columns = getPreferenceString(currentList);
		
		// Save the column data template into the preferences.
		store.setValue(preferenceKey, columns);
	}
	
	/**
	 * @param currentList
	 * @return
	 */
	public static String getPreferenceString(List currentList){
		String columns = ""; //$NON-NLS-1$
		String columnName = ""; //$NON-NLS-1$
		
		for (int i = 0; i < currentList.size(); i++) {
			ColumnData columnData = (ColumnData)currentList.get(i);
			columnName = columnData.getName();
				
			if(columnData.getVisible())
				columns = columns + "|" + columnName + "=1"; //$NON-NLS-1$ //$NON-NLS-2$
			else
				columns = columns + "|" + columnName + "=0";				 //$NON-NLS-1$ //$NON-NLS-2$
		}
		return columns.trim();
	}
		
	/**
	 * 
	 * 
	 * @return java.lang.String
	 */
	public String getName() {
		return _name;
	}
	/**
	 * 
	 * 
	 * @param name java.lang.String
	 */
	public void setName(String name) {
		_name = name;
	}
	
	/**
	 * @param obj
	 */
	public void setObject(Object obj) {
		_obj = obj;
	}	

	/**
	 * @return
	 */
	public Object getObject() {
		return _obj;
	}	
	
	/**
	 * @return
	 */
	public boolean getVisible() {
		return _visible;
	}
	
	/**
	 * @param visible
	 */
	public void setVisible(boolean visible)
	{
		_visible = visible;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer result = new StringBuffer();
		result.append('(');
		if (_obj != null)
			result.append(_obj.getClass().getName()+","); //$NON-NLS-1$
		result.append(" name: "); //$NON-NLS-1$
		result.append(_name);
		result.append(", visible: "); //$NON-NLS-1$
		result.append(_visible);
		result.append(')');
		return result.toString();
	}
	
}