/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.core.ui.util;

import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CompositeDialog extends TitleAreaDialog {
	private CompositePrototype composite;
	private DialogController dialogController;
	
	private String title;
	private String message;
	
	private Composite c;

	public CompositeDialog(Shell parent, CompositePrototype composite, DialogController dialogController, String title, String message) {
		super(parent);
		this.setShellStyle(getShellStyle() | SWT.MAX | SWT.RESIZE);
		this.composite = composite;
		this.dialogController = dialogController;
		this.title = title;
		this.message = message;
	} 
	
	public Composite getDefaultComposite() {
		return c;
	}
	
	protected Control createDialogArea(Composite parent) {
		this.setBlockOnOpen(true);
		Composite container = (Composite) super.createDialogArea(parent);
		container.setLayout(new GridLayout());
		container.setLayoutData(new GridData(GridData.FILL_BOTH));

		setTitle(title);				
		setMessage(message, IMessageProvider.INFORMATION);

		c = composite.clone();
		c.setParent(container);
		return c;
	}
	
	protected void okPressed() {
		if(this.dialogController != null)
			dialogController.handleOK();
		super.okPressed();
	}
	
	public static CompositeDialog createDialog(Composite composite, DialogController controller,String title,String message) {
		class composite implements CompositePrototype {
			private Composite c;
			private DialogController controller;
			
			public composite(Composite c, DialogController controller) {
				this.c = c; 
				this.controller = controller; 									
			}
			
			public Composite clone() {
				return c;
			}	
			
			public DialogController getController() {
				return controller; 
			}
		}

		composite c = new composite(composite, controller);
		CompositeDialog d = new CompositeDialog(composite.getShell(),c,c.getController(),title,message);
		return d;
	}
}
