/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dpp.uei;

import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DeviceDescription;
import org.eclipse.mtj.api.devices.DevicesFactory;
import org.eclipse.mtj.core.toolkit.DevicePlatformImporter;
import org.eclipse.mtj.executable.uei.AbstractUeiDevicePlatformImporter;

/** 
 * Generic UEI specific Device Platform importer. 
 * Enables the import of device platforms that conform to the UEI specification.
 * Vendor specific implemenations should extend this class.*/
public class GenericUeiDevicePlatformImporter extends AbstractUeiDevicePlatformImporter implements DevicePlatformImporter{

	public boolean hasDebugServer() {
		return true;
	}
	
	public boolean isPredeployRequired() {
		return true;
	}
	
	public String getLaunchCommand() {
		return "%executable% " + //$NON-NLS-1$
		   "[%debugPort%|-Xdebug -Xrunjdwp:transport=dt_socket,suspend=y,server=y,address=%debugPort%] " + //$NON-NLS-1$
	   	   "-classpath \"%classpath%\" -Xdevice:%device% [%jadfile%|\"-Xdescriptor:%jadfile%\"] [%verbose%|-Xverbose:%verbose%] " + //$NON-NLS-1$
	       "[%heapsize%|-Xheapsize:%heapsize%] [%securityDomain%|-Xdomain:%securityDomain%] %userSpecifiedArguments% " + //$NON-NLS-1$
	       " [%otaurl%|-Xjam:transient=%otaurl%]"; //$NON-NLS-1$
	}

	/** 
	 * Returns the vendor name that will be used in the UI.
	 * Because accessing the vendor name is not specified in the UEI specification, 
	 * vendors should provide own implementation on how to get this value.*/
	public String getVendor(){
		return Messages.GenericUeiDevicePlatformImporter_GenericVendor;
	}
	
	/**
	 * Return the runttime platform definition name that will be used for the device.
	 * The vendors should provide own implementation on how to get this value.
	 * Default value will be the "vendorName deviceName Runtime Platform"
	 */
	public String getRuntimePlatformDefinitionName(String deviceName){
		
		StringBuffer sb = new StringBuffer();
		sb.append(getVendor());
		sb.append(" "); //$NON-NLS-1$
		sb.append(deviceName);
		sb.append(Messages.GenericUeiDevicePlatformImporter_RuntimePlatform);

		return sb.toString();
	}
	
	
	public DeviceDescription createDeviceDescription(String deviceName){
		
		DeviceDescription dd = DevicesFactory.eINSTANCE.createDeviceDescription();
		
		dd.setIdentifier(getDeviceDescriptionIdentifier(deviceName));
		
		//TODO Create device capabilities
		//DevicesFactory.eINSTANCE.createDeviceCapability();
		
		//TODO Create device features
		//DevicesFactory.eINSTANCE.createDeviceFeature()
		
		return dd;
	}
	
	private String getDeviceDescriptionIdentifier(String deviceName) {

		return getVendor()+" "+deviceName; //$NON-NLS-1$
	}
	
	public void createDeviceDetails(Device device){
		
		//Version
		device.setVersion(Messages.GenericUeiDevicePlatformImporter_DeviceDetailsVersion);
		//Vendor
		device.setVendor(getVendor());
		//Description
		device.setDescription(Messages.GenericUeiDevicePlatformImporter_DeviceDetailsDescription);
	}


}
