/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dm.model;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.api.extension.DevicePlatformProvider;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.toolkit.ToolkitSupport;
import org.eclipse.mtj.extension.dm.Messages;

public class MtjServiceHandler {
	private static final Logger log = Logger.getLogger(MtjServiceHandler.class.getName());

	public DevicePlatform[] getDevicePlatforms() {
		try {
		DeviceManagement dm = (DeviceManagement) MtjServices.getInstance().getImplementations(
				ExtensionType.DEVICE_MANAGEMENT_LITERAL, null,
				null, true)[0];
			return dm.getDevicePlatforms();
		} catch (Exception e) {
			log.log(Level.WARNING,Messages.MtjServiceHandler_CouldNotProvideDevicePlatforms,e);
		}
		return new DevicePlatform[0];
	}
	
	public static boolean setDevicePlatforms(DevicePlatform[] dps) {
		BasicEMap dppMap = new BasicEMap();
		
		for(int i = 0; i < dps.length; i++) {
			DevicePlatform dp = dps[i];
			DevicePlatformProvider dpp = (DevicePlatformProvider) dp.getDevicePlatformProvider();
			
			if(!dppMap.containsKey(dpp)) {
				EList l = new BasicEList();
				l.add(dp);
				dppMap.put(dpp, l);				
			} else {
				EList l = (EList)dppMap.get(dpp);
				l.add(dp);
			}						
		}
		
		Iterator iterator = dppMap.keySet().iterator();
		while (iterator.hasNext()) {
			Object o = iterator.next();
			if(o instanceof ToolkitSupport) {
				ToolkitSupport tk = (ToolkitSupport) o;
				EList l = (EList) dppMap.get(tk);
				DevicePlatform[] dpa = new DevicePlatform[l.size()];
				for (int i = 0; i < l.size(); i++) {
					dpa[i] = (DevicePlatform) l.get(i);
				}
				try {
					tk.setDevicePlatforms(dpa);
				} catch (Exception e) { 
					log.log(Level.WARNING, Messages.MtjServiceHandler_CouldNotSaveDevicePlatforms, e);
					return false;
				}
			}
		}
		
		return true;
	}
}

