/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dm.preferences;

import java.util.Iterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.ui.util.DialogController;
import org.eclipse.mtj.extension.dm.Messages;
import org.eclipse.mtj.extension.dm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.dm.ui.preferences.DeviceInfoComposite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DeviceInfoController implements DialogController {
	private MtjServiceHandler mtjServiceHandler;
	private Device selectedDevice;
	private DeviceInfoComposite composite;
	private TableViewer apiTableViewer;
	
	
	public DeviceInfoController(Device selectedDevice, MtjServiceHandler mtjServiceHandler, DeviceInfoComposite composite) {
		this.composite = composite;
		this.selectedDevice = selectedDevice;
		this.mtjServiceHandler = mtjServiceHandler;
		
		this.apiTableViewer = composite.getOptionalApiTableViewer();
		
		setData();
	}
	
	private void setData() {
		composite.getDeviceNameLabel().setText(selectedDevice.getName());
		composite.getDeviceDescriptionLabel().setText(selectedDevice.getDescription());

		EList l = selectedDevice.getRuntimePlatformDefinitions();
		RuntimePlatformDefinition rpd = (RuntimePlatformDefinition)l.get(0);
		
		createProfile(rpd);
		createConfiguration(rpd);
		createServiceApi(rpd);
	}

	public static Button createRadioButton(Group parent, String label) {		
		Button button = new Button(parent, SWT.CHECK);
		button.setFont(parent.getFont());
		if (label != null){
			button.setText(label);
		}
		return button;	
	}
	
	private boolean containsProfile(String profileName, String profileVersion, Iterator iterator) {		
		while(iterator.hasNext()) {	
			DeviceProfile dp = (DeviceProfile)iterator.next();
			if(dp.getName().equals(profileName) && dp.getVersion().equals(profileVersion)) {
				return true;
			}
		}
		return false;
	}
	
	private boolean containsConfiguration(String configurationName, String configurationVersion, Iterator iterator) {		
		while(iterator.hasNext()) {	
			DeviceConfiguration dc = (DeviceConfiguration)iterator.next();
			if(dc.getName().equals(configurationName) && dc.getVersion().equals(configurationVersion)) {
				return true;
			}
		}
		return false;
	}
	
	private void createProfile(RuntimePlatformDefinition rpd) {
		EList l = rpd.getDeviceProfiles();
		
		Group group = composite.getProfileGroup();

		if(!containsProfile("MIDP","1.0",l.iterator())) { //$NON-NLS-1$ //$NON-NLS-2$
			Button button = createRadioButton(group, "MIDP"+" 1.0");			 //$NON-NLS-1$ //$NON-NLS-2$
			button.setEnabled(false);
		}
		
		for(int i = 0; i < l.size(); i++) {
			DeviceProfile dp = (DeviceProfile) l.get(i);
			String dps = dp.getName()+" "+dp.getVersion(); //$NON-NLS-1$
			Button button = createRadioButton(group, dps);
			button.setSelection(true);
		}	
	}
	
	private void createConfiguration(RuntimePlatformDefinition rpd) {
		EList l = rpd.getDeviceConfigurations();

		Group group = composite.getConfigGroup();

		if(!containsConfiguration("CLDC","1.0",l.iterator())) { //$NON-NLS-1$ //$NON-NLS-2$
			Button button = createRadioButton(group, "CLDC"+" 1.0");			 //$NON-NLS-1$ //$NON-NLS-2$
			button.setEnabled(false);
		}

		for(int i = 0; i < l.size(); i++) {
			DeviceConfiguration dc = (DeviceConfiguration) l.get(i);
			String dcs = dc.getName()+" "+dc.getVersion(); //$NON-NLS-1$
			Button button = createRadioButton(group, dcs);
			button.setSelection(true);
		}
	}

	private void createServiceApi(RuntimePlatformDefinition rpd) {
		class tlp extends LabelProvider implements ITableLabelProvider {
			public Image getColumnImage(Object element, int columnIndex) {
				  return null;
			}
			
			public String getColumnText(Object element, int columnIndex) {
				if(element instanceof ServiceApi) {
					ServiceApi api = (ServiceApi) element;
					if(columnIndex == 0) { return api.getName(); }
					else if(columnIndex == 1) { return api.getVersion(); }
					else if(columnIndex == 2) { return api.getDescription(); }
				}
				return null;
			}			
		}
		
		class EListContentProvider implements IStructuredContentProvider 
		{
			public Object[] getElements(Object o) {
				if(o instanceof EList) {
					return ((EList)o).toArray();
				}
				return null;
			}
			
			public void dispose() {
			}
			
			public void inputChanged(Viewer viewer,
	                Object oldInput,
	                Object newInput) {
			}
		}

		this.apiTableViewer.setContentProvider(new EListContentProvider());
		this.apiTableViewer.setLabelProvider(new tlp());
		
		createTableColumn(this.apiTableViewer.getTable(),0,60,Messages.DeviceInfoController_Name);
		createTableColumn(this.apiTableViewer.getTable(),1,40,Messages.DeviceInfoController_Version);
		createTableColumn(this.apiTableViewer.getTable(),2,300,Messages.DeviceInfoController_Description);
		
		EList rpApiList = rpd.getServiceApis();
		this.apiTableViewer.setInput(rpApiList);
	}

	private static void createTableColumn(Table table, int colIndex, int weight, String header) {
		TableColumn tableColumn = new TableColumn(table, SWT.NONE, colIndex);
		tableColumn.setResizable(true);
		tableColumn.setText(header);				
		tableColumn.setWidth(weight);
	}

	public void handleOK() {
		// TODO
	}		
}
