/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dm.preferences;

import java.util.logging.Logger;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.extension.dm.Messages;
import org.eclipse.mtj.extension.dm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.dm.ui.preferences.DevicePlatformListComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DmPreferencePage extends PreferencePage implements IWorkbenchPreferencePage {
	private static Logger log = Logger.getLogger(DmPreferencePage.class.getName());

	private DevicePlatformListComposite deviceComposite;
	private DevicePlatformListController deviceController;
	
	public DmPreferencePage() {
		super();
		log.info(Messages.DmPreferencePage_ConstructingDmPreferencePage);
		setTitle(Messages.DmPreferencePage_DevicePlatform);
		setDescription(Messages.DmPreferencePage_CreateAndModifyDevicePlatforms);
		noDefaultAndApplyButton();
	}

	protected Control createContents(Composite parent) {
		deviceComposite = new DevicePlatformListComposite(parent);
		deviceController = new DevicePlatformListController(deviceComposite);
		return deviceComposite;
	}

	public void init(IWorkbench workbench) {
	}

	public boolean performOk() {
		boolean okToStore = MtjServiceHandler.setDevicePlatforms(deviceController.getDevicePlatforms());
		log.info("DMPreferencePage OK Performed " +okToStore); //$NON-NLS-1$
		if (okToStore) {
			return super.performOk();
		} else {
			return okToStore;
		}
	}	

}
