/*******************************************************************************
* Copyright  2005 Nokia Corporation
 * Copyright (c) 2003-2005 Craig Setera
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: 
 * Nokia - Initial API and implementation 
 * Craig Setera - partial implementation 
*******************************************************************************/

package org.eclipse.mtj.executable.uei;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimesFactory;
import org.eclipse.mtj.api.runtimes.ServiceApi;

public class ServiceApiManifestImporter extends AbstractServiceApiImporter {

	// private static final String DEPENDENCIES = "API-Dependencies";
	private static final String VERSION = "API-Specification-Version"; //$NON-NLS-1$
	private static final String IDENTIFIER = "API"; //$NON-NLS-1$
	private static final String NAME = "API-Name"; //$NON-NLS-1$ 
	private static final String TYPE = "API-Type"; //$NON-NLS-1$
	private static final String TYPE_PROFILE = "Profile"; //$NON-NLS-1$
	private static final String TYPE_CONFIGURATION = "Configuration"; //$NON-NLS-1$
	private static final String TYPE_OPTIONAL = "Optional"; //$NON-NLS-1$
	private static final int API_UNKNOWN = 0;
	private static final int API_OPTIONAL = 1;
	private static final int API_PROFILE = 2;
	private static final int API_CONFIGURATION = 3;

	
	private static IServiceApiImporter instance;
	
	public static IServiceApiImporter getInstance(){
		
		if(instance == null){
			instance = new ServiceApiManifestImporter();
		}
		
		return instance;
	}
	
	/**
	 * Construct a new manifest API importer.
	 */
	private ServiceApiManifestImporter() {
		super();
	}
	
	public ServiceApi[] getServiceApis(File libraryFile) {
		
		ServiceApi api = null;
		
		Attributes attributes = getAttributes(libraryFile);
		if (attributes != null) {
			
			if(getType(attributes) == API_OPTIONAL){
			
				String identifier = attributes.getValue(IDENTIFIER);
				if (identifier != null) {
					
					api = RuntimesFactory.eINSTANCE.createServiceApi();
					api.setName(identifier);
					api.setDescription(attributes.getValue(NAME));
					api.setVersion(getVersion(attributes));
					
					ImplementationRef implRef = RuntimesFactory.eINSTANCE.createImplementationRef();
					implRef.setFileRef(libraryFile.getAbsolutePath());
					api.setImplementation(implRef);
				}
			}
		}
		
		return (api == null) ? null : new ServiceApi[] { api };
	}

	/**
	 * Return the manifest attributes for the library file or 
	 * <code>null</code> if they could not be located.
	 * 
	 * @param libraryFile 
	 * @return
	 */
	private Attributes getAttributes(File libraryFile) {
		Attributes attributes = null;
		
		try {
			JarFile jarFile = new JarFile(libraryFile);
			if (jarFile != null) {
				
				Manifest manifest = jarFile.getManifest();
				if (manifest != null) {
					attributes = manifest.getMainAttributes();
				}
			}
		} catch (IOException e) {
		}

		return attributes;
	}

	@Override
	public DeviceConfiguration[] getConfigurationApis(File libraryFile) {
		
		DeviceConfiguration api = null;
		
		Attributes attributes = getAttributes(libraryFile);
		if (attributes != null) {
			
			if(getType(attributes) == API_CONFIGURATION){
			
				String identifier = attributes.getValue(IDENTIFIER);
				if (identifier != null) {
					
					api = RuntimesFactory.eINSTANCE.createDeviceConfiguration();
					api.setName(identifier);
					api.setVersion(getVersion(attributes));
					
					ImplementationRef implRef = RuntimesFactory.eINSTANCE.createImplementationRef();
					implRef.setFileRef(libraryFile.getAbsolutePath());
					api.setImplementation(implRef);
				}
			}
		}
		
		return (api == null) ? null : new DeviceConfiguration[] { api };
	}

	@Override
	public DeviceProfile[] getProfileApis(File libraryFile) {
		
		DeviceProfile api = null;
		
		Attributes attributes = getAttributes(libraryFile);
		if (attributes != null) {
			
			if(getType(attributes) == API_PROFILE){
			
				String identifier = attributes.getValue(IDENTIFIER);
				if (identifier != null) {
					
					api = RuntimesFactory.eINSTANCE.createDeviceProfile();
					api.setName(identifier);
					api.setVersion(getVersion(attributes));
				}
			}
		}
		
		return (api == null) ? null : new DeviceProfile[] { api };
	}

	/**
	 * Return the integer type of the value specified 
	 * in the manifest.
	 * 
	 * @param attributes
	 * @return
	 */
	private int getType(Attributes attributes) {
		
		int type = API_UNKNOWN;
		String typeString = attributes.getValue(TYPE);
		
		if(typeString == null){
			return type;
		}
		else if (typeString.equalsIgnoreCase(TYPE_OPTIONAL)) {
			type = API_OPTIONAL;
		} else if (typeString.equalsIgnoreCase(TYPE_PROFILE)) {
			type = API_PROFILE;
		} else if (typeString.equalsIgnoreCase(TYPE_CONFIGURATION)) {
			type = API_CONFIGURATION;
		}
		
		return type;
	}

	/**
	 * Return the version of the API as found in the
	 * attributes.
	 * 
	 * @param attributes
	 * @return
	 */
	private String getVersion(Attributes attributes) {
		
		String versionString = attributes.getValue(VERSION);
		if (versionString == null) {
			versionString = "0.0.0"; //$NON-NLS-1$
		}
		
		return versionString;
	}
}
