/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM - initial API and implementation
 *******************************************************************************/

package org.eclipse.mtj.extension.smgmt.impl.IBM;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.extension.smgmt.IBM.SecurityManagementPlugin;

/**
 * Class used to initialize default preference values.
 */
public class PreferenceInitializer extends AbstractPreferenceInitializer {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		IPreferenceStore store = SecurityManagementPlugin.getDefault()
				.getPreferenceStore();
		//Set default value here. Can be blank
		//store.setDefault(SecurityManagementImplConstants.SECURITY_TOOL_LOCATION, "C:\\Program Files\\IBM\\Java50\\bin\\keytool.exe"); //$NON-NLS-1$
		store.setDefault(SecurityManagementImplConstants.SECURITY_TOOL_LOCATION, Messages.PreferenceInitializer_0); 
	}

}
