/******************************************************************************* 
 * Copyright (c) 2005 Nokia Corporation                                         
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Nokia -  Initial API and implementation 
 *******************************************************************************/ 
package org.eclipse.mtj.api.model.packaging;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.model.IMtjProject;

public class MidpPackagingResources {

	IFolder verifiedClassesOutputFolder;
	IFolder verifiedLibrariesOutputFolder;

	public MidpPackagingResources(IResource[] resources) {
		this.verifiedClassesOutputFolder = (IFolder)resources[0];
		this.verifiedLibrariesOutputFolder = (IFolder)resources[1];
	}
	
	public MidpPackagingResources(IMtjProject project, IProgressMonitor monitor) throws CoreException {
		this.verifiedClassesOutputFolder = project.getVerifiedClassesOutputFolder(monitor);
		this.verifiedLibrariesOutputFolder = project.getVerifiedLibrariesOutputFolder(monitor);
	}
	
	public MidpPackagingResources() {
	}
	
	public IResource[] getResources() {
		IResource[] res = new IResource[2];
		res[0] = verifiedClassesOutputFolder;
		res[1] = verifiedLibrariesOutputFolder;
		return res;
	}
	
	public IFolder getVerifiedClassesOutputFolder() {
		return verifiedClassesOutputFolder;
	}
	
	public IFolder getVerifiedLibrariesOutputFolder() {
		return verifiedLibrariesOutputFolder;
	}
	
	public void setVerifiedClassesOutputFolder(IFolder folder) {
		verifiedClassesOutputFolder = folder;
	}
	
	public void setVerifiedLibrariesOutputFolder(IFolder folder) {
		verifiedLibrariesOutputFolder = folder;
	}
}
