/**
 * Copyright (c) 2003-2005 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.api.model.preverifier;

/**
 * The location of the error.
 * <p />
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:21 $
 * <br>
 * @author Craig Setera
 */
public class PreverificationErrorLocation {
	private PreverificationErrorLocationType locationType;
	private IClassErrorInformation classInformation;
	private IMethodErrorInformation methodInformation;
	private IFieldErrorInformation fieldInformation;
	private int lineNumber;
	
	/**
	 * Construct a new location object.
	 * 
	 * @param locationType
	 * @param classInformation
	 * @param methodInformation
	 * @param fieldInformation
	 * @param lineNumber
	 */
	public PreverificationErrorLocation(
		PreverificationErrorLocationType locationType, 
		IClassErrorInformation classInformation, 
		IMethodErrorInformation methodInformation, 
		IFieldErrorInformation fieldInformation, 
		int lineNumber) 
	{
		super();

		this.classInformation = classInformation;
		this.fieldInformation = fieldInformation;
		this.lineNumber = lineNumber;
		this.locationType = locationType;
		this.methodInformation = methodInformation;
	}

	/**
	 * Return information about the class in which the error
	 * occurred or <code>null</code> if there is not class
	 * information.
	 * 
	 * @return Returns the class information.
	 */
	public IClassErrorInformation getClassInformation() {
		return classInformation;
	}

	/**
	 * Return information about the field in which the error
	 * occurred or <code>null</code> if there is not field
	 * information.
	 * 
	 * @return Returns the field information.
	 */
	public IFieldErrorInformation getFieldInformation() {
		return fieldInformation;
	}

	/**
	 * @return Returns the lineNumber.
	 */
	public int getLineNumber() {
		return lineNumber;
	}

	/**
	 * Return information about the type of the location in which the error
	 * occurred or <code>null</code> if there is not location type
	 * information.
	 * 
	 * @return Returns the locationType.
	 */
	public PreverificationErrorLocationType getLocationType() {
		return locationType;
	}

	/**
	 * Return information about the method in which the error
	 * occurred or <code>null</code> if there is not method
	 * information.
	 * 
	 * @return Returns the methodInformation.
	 */
	public IMethodErrorInformation getMethodInformation() {
		return methodInformation;
	}
}
