/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dpp.ui.impl;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.ConfigurationItem;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.dpp.impl.DevicePlatformProviderImpl;
import org.eclipse.mtj.extension.dpp.ui.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AdminPage extends Composite {

	private int fieldLength = 250;
	private int fieldHight = 20;
	
	TreeViewer treeViewer;
	
	DevicePlatform platform;

	public AdminPage (Composite parent, int style) {
		super (parent, style);
		
		try {
			DeviceManagement dm = (DeviceManagement) MtjServices.getInstance().getImplementations(
				ExtensionType.DEVICE_MANAGEMENT_LITERAL, null,
				null, true)[0];
		
			DevicePlatform[] dp = dm.getDevicePlatforms();
			// DevicePlatform[] dp = DevicePlatformProviderImpl.getDefault().getDevicePlatforms();
			if(dp.length > 0)
				init(dp[0]);
		} catch (MtjException e) {
			e.printStackTrace();
		}
	}

	protected void init(DevicePlatform platform) {
		this.platform = platform;
		
		GridLayout layout = new GridLayout();
		this.setLayout(layout);
		layout.numColumns = 5;
		layout.marginHeight = 20;
		layout.marginWidth = 20;

		Iterator it = platform.getConfiguration().getItems().iterator();
		while (it.hasNext()) {
			
			ConfigurationItem item = (ConfigurationItem)it.next();
			
			Label label = new Label(this, SWT.NONE);
			GridData gd = new GridData(GridData.BEGINNING);
			gd.horizontalSpan = 1;
			label.setLayoutData(gd);
			label.setText(item.getLabel() != null ? item.getLabel() : ""); //$NON-NLS-1$
	
			int span = 4;
			if ( item.getValue() != null &&
				( item.getValue().indexOf("\\") != -1 || //$NON-NLS-1$
				  item.getValue().indexOf("/") != -1 ) ) { //$NON-NLS-1$
				span = 1;
			}
			
			Text swt_text = new Text(this, SWT.BORDER);
			gd = new GridData(GridData.BEGINNING);
			gd.horizontalSpan = span;
			gd.widthHint = fieldLength;
			gd.heightHint = fieldHight;
			swt_text.setLayoutData(gd);
			swt_text.setText(item.getValue() != null ? item.getValue() : ""); //$NON-NLS-1$
			swt_text.setToolTipText(item.getDescription() != null ? item.getDescription() : ""); //$NON-NLS-1$
			swt_text.addModifyListener(new ModifyListenerImpl(item, swt_text));
			
			if ( span == 1 ) {
				Button swt_button = new Button(this, SWT.PUSH);
				gd = new GridData(GridData.BEGINNING);
				gd.horizontalSpan = 3;
				gd.heightHint = fieldHight;
				swt_button.setLayoutData(gd);
				swt_button.addMouseListener(new DirectoryDialogMouseAdapter(swt_text));
				swt_button.setBounds(0,0,fieldHight,fieldHight);
				swt_button.setText("..."); //$NON-NLS-1$
			}
		}
		
		Label empty_row = new Label(this, SWT.NONE);
		GridData gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 5;
		empty_row.setLayoutData(gd);
		empty_row.setText(""); //$NON-NLS-1$
		
		Button swt_button_save = new Button(this, SWT.PUSH);
		gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 5;
		gd.heightHint = fieldHight;
		swt_button_save.setLayoutData(gd);
		swt_button_save.addMouseListener(new MouseAdapter() {
		      public void mouseDown(MouseEvent mouseEvent) {
			        buttonAction_save();
			      }
			    });
		swt_button_save.setBounds(0,0,fieldHight,fieldHight);
		swt_button_save.setText(Messages.AdminPage_Save);

		Label empty_row2 = new Label(this, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 5;
		empty_row2.setLayoutData(gd);
		empty_row2.setText(""); //$NON-NLS-1$
		
		treeViewer = new TreeViewer(this, SWT.SINGLE);
		gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 5;
		gd.widthHint = 550;
		gd.heightHint = 230;
		treeViewer.getTree().setLayoutData(gd);
		treeViewer.setLabelProvider(new TreeViewLabelProvider());
		treeViewer.setContentProvider(new TreeViewContentProvider());
		Object[] in = { platform };
		treeViewer.setInput(in);
		treeViewer.addSelectionChangedListener(new TreeViewSelectionChangedListener());
	}

	private void buttonAction_save() {
		try {
			DevicePlatformProviderImpl.getDefault().setDevicePlatform(platform);
		} catch (MtjException e) {
			// TODO Show error message
			e.printStackTrace();
		}
	}
	
	public class DirectoryDialogMouseAdapter implements MouseListener {
		  Text swt_text;
		  public DirectoryDialogMouseAdapter(Text swt_text) {
			  this.swt_text = swt_text;
		  }
	      public void mouseDown(MouseEvent mouseEvent) {
		  		Shell shell = MtjCorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
		  		DirectoryDialog dialog = new DirectoryDialog(shell, SWT.OPEN);
				String selectedFileName = dialog.open();
				if (selectedFileName != null) {
					swt_text.setText(selectedFileName);
				}
		  }		
	      public void mouseDoubleClick(MouseEvent e) {
	    	  System.out.println();
	      }
	      public void mouseUp(MouseEvent e) {
	    	  System.out.println();
	      }
	}
	
	class ModifyListenerImpl implements ModifyListener {
		ConfigurationItem item;
		Text text;
		public ModifyListenerImpl(ConfigurationItem item, Text text) {
			this.item = item;
			this.text = text;
		}
		public void modifyText(ModifyEvent e) {
			item.setValue(text.getText());
		}
	}
	
	class TreeViewLabelProvider extends org.eclipse.jface.viewers.LabelProvider {

		public String getText(Object obj) {
			if (obj instanceof DevicePlatform) {
				return Messages.AdminPage_Platform + ((DevicePlatform)obj).getName();
			}
			else if (obj instanceof Device) {
				return Messages.AdminPage_Device + ((Device)obj).getName();
			}
			else if (obj instanceof RuntimePlatformDefinition) {
				return Messages.AdminPage_RPD + ((RuntimePlatformDefinition)obj).getName();
			}
			else if (obj instanceof DeviceProfile) {
				return Messages.AdminPage_DeviceProfile + ((DeviceProfile)obj).getName() + ", " + ((DeviceProfile)obj).getVersion(); 
			}
			else if (obj instanceof DeviceConfiguration) {
				return Messages.AdminPage_DeviceConfiguration + ((DeviceConfiguration)obj).getName() + ", " + ((DeviceConfiguration)obj).getVersion(); 
			}
			else if (obj instanceof ServiceApi) {
				return Messages.AdminPage_ServiceApi + ((ServiceApi)obj).getName() + ", " + ((ServiceApi)obj).getVersion(); 
			}
			else if (obj instanceof ImplementationRef) {
				return Messages.AdminPage_File + ((ImplementationRef)obj).getFileRef();
			}
			return obj.toString();
		}
		
		public Image getImage(Object obj) {
			return null;
		}
	}
	
	class TreeViewContentProvider implements ITreeContentProvider {
	    public Object[] getChildren(Object parentElement) {
	    	if ( parentElement instanceof DevicePlatform ) {
	    		ArrayList list = new ArrayList();
	    		Iterator it = ((DevicePlatform)parentElement).getDevices().iterator();
	    		while (it.hasNext()) {
	    			list.add(it.next());
	    		}
	    		it = ((DevicePlatform)parentElement).getRuntimePlatformDefinitions().iterator();
	    		while (it.hasNext()) {
	    			list.add(it.next());
	    		}
	    		return list.toArray();
	    	}
	    	else if ( parentElement instanceof Device ) {
	    		ArrayList list = new ArrayList();
	    		Iterator it = ((Device)parentElement).getRuntimePlatformDefinitions().iterator();
	    		while (it.hasNext()) {
	    			list.add(it.next());
	    		}
	    		return list.toArray();
	    	}
	    	else if ( parentElement instanceof RuntimePlatformDefinition ) {
	    		ArrayList list = new ArrayList();
	    		Iterator it = ((RuntimePlatformDefinition)parentElement).getDeviceProfiles().iterator();
	    		while (it.hasNext()) {
	    			list.add(it.next());
	    		}
	    		it = ((RuntimePlatformDefinition)parentElement).getServiceApis().iterator();
	    		while (it.hasNext()) {
	    			list.add(it.next());
	    		}
	    		it = ((RuntimePlatformDefinition)parentElement).getDeviceConfigurations().iterator();
	    		while (it.hasNext()) {
	    			list.add(it.next());
	    		}
	    		return list.toArray();
	    	}
	    	else if ( parentElement instanceof DeviceProfile ) {
	    		ArrayList list = new ArrayList();
	    		Iterator it = ((DeviceProfile)parentElement).getServiceApis().iterator();
	    		while (it.hasNext()) {
	    			list.add(it.next());
	    		}
	    		return list.toArray();
	    	}
	    	else if ( parentElement instanceof DeviceConfiguration ) {
	    		ArrayList list = new ArrayList();
	    		list.add(((DeviceConfiguration)parentElement).getImplementation());
	    		return list.toArray();
	    	}
	    	else if ( parentElement instanceof ServiceApi ) {
	    		ArrayList list = new ArrayList();
	    		list.add(((ServiceApi)parentElement).getImplementation());
	    		return list.toArray();
	    	}
	    	else if ( parentElement instanceof Object[] ) {
	    		return (Object[])parentElement;
	    	}
	    	return null;
	    }
	    public Object getParent(Object element) {
	    	return null;
	    }
	    public boolean hasChildren(Object element) {
	    	return true;
	    }
	    public Object[] getElements(Object inputElement) {
	    	return getChildren(inputElement);
	    }
	    public void dispose() {
	    	
	    }
	    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	    	
	    }
	}

	class TreeViewSelectionChangedListener implements ISelectionChangedListener {
	    public void selectionChanged(SelectionChangedEvent event) {
	    	if ( event.getSelection() instanceof StructuredSelection && ((StructuredSelection)event.getSelection()).size() > 0) {
	    		Object f = ((StructuredSelection)event.getSelection()).getFirstElement();

	    	}
	    }
	}

}
