/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM - initial API and implementation
 *******************************************************************************/
package org.eclipse.mtj.extension.sp.ui.eclipse.preferences;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.window.Window;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.SigningProvider;
import org.eclipse.mtj.core.ui.util.GridUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.sp.ui.utils.SpUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */

public class SigningPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {

	private MtjExtension[] signingList;

	private Button editButton;
	private TableItem lastEnabled = null;
	
	private Table SigningToolPathTable;
	
	public SigningPreferencePage() {
		setDescription(Messages.SigningPreferencePage_0 + 
				Messages.SigningPreferencePage_1 + 
				Messages.SigningPreferencePage_2); 
		noDefaultAndApplyButton();

		try {
			signingList = (SigningProvider[])SpUtils.getSigningProvidersList();
		} catch (MtjException e) {
			signingList = null;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}

	@Override
	protected Control createContents(Composite parent) {
		
		if (signingList == null){
			setErrorMessage(Messages.SigningPreferencePage_10);
		}
		else if (signingList.length <= 0){
			setErrorMessage(Messages.SigningPreferencePage_3); 
		}
	
		setDescription(Messages.SigningPreferencePage_4 ); 
		
		Composite mainPageComposite = new Composite(parent, SWT.BORDER);

		GridLayout c1gridLayout = new GridLayout();
		c1gridLayout.numColumns = 2;
		
		mainPageComposite.setLayout(c1gridLayout);
		GridData dataMain = GridUtil.createFill();
        mainPageComposite.setLayoutData(dataMain);

        Composite tableComposite = new Composite(mainPageComposite, SWT.NULL);
        FillLayout fillLayout = new FillLayout();
        tableComposite.setLayout(fillLayout);
        GridData gdTableComp = new GridData(GridData.FILL_BOTH);
        tableComposite.setLayoutData(gdTableComp);
		
		SigningToolPathTable = new Table(tableComposite, SWT.CHECK  | SWT.SINGLE | SWT.FULL_SELECTION | SWT.BORDER);		
		
		SigningToolPathTable.setHeaderVisible(true);
		SigningToolPathTable.setLinesVisible(true);
		SigningToolPathTable.setFont(parent.getFont());
		
		TableColumn activeColumn = new TableColumn(SigningToolPathTable, SWT.NONE);
		activeColumn.setText(Messages.SigningPreferencePage_9); 
		
		TableColumn SignProvVendorName = new TableColumn(SigningToolPathTable, SWT.NONE);
		SignProvVendorName.setText(Messages.SigningPreferencePage_5); 
		
		TableColumn SignProvVersion = new TableColumn(SigningToolPathTable, SWT.LEFT);
		SignProvVersion.setText(Messages.SigningPreferencePage_6); 
		
		TableColumn SigProvLocation = new TableColumn(SigningToolPathTable, SWT.LEFT);
		SigProvLocation.setText(Messages.SigningPreferencePage_7); 

		if (signingList != null && signingList.length > 0) {
			for(int i = 0; i < signingList.length; i++){
				TableItem item = new TableItem(SigningToolPathTable,SWT.NONE);
				
				item.setText(SigningPreferenceConstants.activeindex, signingList[i].getDescription());
				item.setText(SigningPreferenceConstants.SignProvVendorNameIndex, signingList[i].getVendor());
				item.setText(SigningPreferenceConstants.SignProvVersionIndex, signingList[i].getVersion());
				try {
					item.setText(SigningPreferenceConstants.SignProvLocationIndex, ((SigningProvider)signingList[i]).getToolLocation(new NullProgressMonitor()));
				} catch (MtjException e1) {
					item.setText(SigningPreferenceConstants.SignProvLocationIndex, ""); //$NON-NLS-1$
					e1.printStackTrace();
				}
	
				if (((SigningProvider)signingList[i]).isActive())
				{
					if (lastEnabled != null){
						if (lastEnabled.equals(item))
							item.setChecked(true);
						else
							item.setChecked(false);
					}
					else{
						item.setChecked(true);
						lastEnabled = item;						
					}
					
				} else {
					item.setChecked(false);
				}			
			}
		}
		activeColumn.pack();
		SignProvVendorName.pack();
		SignProvVersion.pack();
		SigProvLocation.pack();
		SigningToolPathTable.pack();
		
		SigningToolPathTable.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				editButton.setEnabled(true);		
				if (event.detail == SWT.CHECK)
				{
					if (lastEnabled == null){
						((TableItem)event.item).setChecked(true);
						lastEnabled = (TableItem)event.item;
					}
					else if (!lastEnabled.equals((TableItem)event.item)){
						lastEnabled.setChecked(false);
						((TableItem)event.item).setChecked(true);
						lastEnabled = (TableItem)event.item;
					}
				}
				return;
			}
		});
			
		Composite rightColumnButtons = new Composite(mainPageComposite, SWT.BORDER);
		GridData gd = new GridData();
		gd.grabExcessVerticalSpace = true;
		gd.horizontalIndent = 10;
		gd.verticalAlignment = GridData.FILL;
		
        rightColumnButtons.setLayoutData(gd);
		gd.horizontalSpan = 1;

		GridLayout c1gridLayoutButtons = new GridLayout();
		c1gridLayoutButtons.numColumns = 1;
		rightColumnButtons.setLayout(c1gridLayoutButtons);

		editButton =  new Button(rightColumnButtons, SWT.PUSH);
		editButton.setText(Messages.SigningPreferencePage_8); 

		editButton.setEnabled(false);
		editButton.addSelectionListener(new SelectionAdapter (){
			public void widgetSelected(SelectionEvent e) {
				TableItem ti = SigningToolPathTable.getSelection()[0];
				SigningProviderEditor signingProviderEditor = new SigningProviderEditor(getShell(),ti.getText(SigningPreferenceConstants.SignProvVendorNameIndex), ti.getText(SigningPreferenceConstants.SignProvVersionIndex), ti.getText(SigningPreferenceConstants.SignProvLocationIndex), ti.getText(SigningPreferenceConstants.activeindex));
				signingProviderEditor.open();
				if(signingProviderEditor.getReturnCode() == Window.OK){
					ti.setText(SigningPreferenceConstants.SignProvVendorNameIndex, signingProviderEditor.getName());
					ti.setText(SigningPreferenceConstants.SignProvVersionIndex, signingProviderEditor.getVersion());
					ti.setText(SigningPreferenceConstants.SignProvLocationIndex, signingProviderEditor.getPath());	
					
				}
			}
		});

		return mainPageComposite;
	}
	
	public boolean performOk() {
		
		boolean okToStore = false; //SmgmtUtils.storeSecurityManagers(SecurityToolPathTable.get);
		
		for(int i = 0; i < signingList.length; i++){
		try {
			((SigningProvider)signingList[i]).storeToolLocation(SigningToolPathTable.getItem(i).getText(SigningPreferenceConstants.SignProvLocationIndex), null);
			((SigningProvider)signingList[i]).setActive(SigningToolPathTable.getItem(i).getChecked());
		} catch (MtjException e) {
			e.printStackTrace();
		}
	}
		okToStore = SpUtils.storeSigningProviders(signingList);

		if (okToStore) {
			return super.performOk();
		} else {
			return okToStore;
		}
	}
}