/**
 * Copyright (c) 2003-2005 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.extension.devide.jadeditor;

import org.eclipse.mtj.core.jad.IJADConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

/**
 * JAD editor page for handling the over the air properties.
 * <p />
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.2 $
 * <br>
 * $Date: 2006/09/05 15:12:25 $
 * <br>
 * @author Craig Setera
 */
public class JADOTAPropertiesEditorPage extends JADPropertiesEditorPage {
	public static final String ID = "ota";
	
	/**
	 * OTA property descriptors.
	 */
	private static final DescriptorPropertyDescription[] 
		OTA_DESCRIPTORS = new DescriptorPropertyDescription[] {
			new DescriptorPropertyDescription(
				IJADConstants.JAD_MIDLET_DELETE_CONFIRM,
				JadEditorStrings.property_jad_midlet_delete_confirm,
				DescriptorPropertyDescription.DATATYPE_STRING),
			new DescriptorPropertyDescription(
				IJADConstants.JAD_MIDLET_DELETE_NOTIFY,
				JadEditorStrings.property_jad_midlet_delete_notify,
				DescriptorPropertyDescription.DATATYPE_URL),
			new DescriptorPropertyDescription(
				IJADConstants.JAD_MIDLET_INSTALL_NOTIFY,
				JadEditorStrings.property_jad_midlet_install_notify,
				DescriptorPropertyDescription.DATATYPE_URL),
		};

	/**
	 * Constract a new required properties editor.
	 * 
	 * @param editor
	 */
	public JADOTAPropertiesEditorPage(JADEditor editor) {
		super(editor, ID, "OTA", OTA_DESCRIPTORS);
	}

	/**
	 * @see org.eclipse.mtj.extension.devide.jadeditor.AbstractJADEditorPage#getSectionTitle()
	 */
	protected String getSectionTitle() {
		return "Over The Air Properties";
	}

	/**
	 * @see org.eclipse.mtj.extension.devide.jadeditor.AbstractJADEditorPage#getSectionDescription()
	 */
	protected String getSectionDescription() {
		return "Properties related to Over the Air deployment may be specified on this page";
	}
	
	protected void addContextHelp(Composite c)
	{
		PlatformUI.getWorkbench().getHelpSystem().setHelp(c, "eclipseme.ui.help_JADOTAPropertiesEditorPage");
	}
}
