/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import java.util.Properties;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.exception.MtjException;

/**
 * Packaging Provider is responsible of creating deployment packages from application projects resources.
 * <p>
 * 
 * </p>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:20 $
 * <br>
 */
public interface PackagingProvider extends BuildExtension {

	/**
	 * Method returns the deployment types that are supported by itself.
	 * 
	 * @return
	 */
	public DeploymentType[] getSupportedTypes() throws MtjException;

	/**
	 * Method creates deployment package from the resources.
	 * Realization of the result Deployment object depends on the deployment type. 
	 * Valid types are: f.ex. MIDlet, CDC, MEGlet.
	 * Also resource objects are depending on the type.
	 * Created deployments are created to folder that is defined by targetFolder attribute. 
	 * I.e. MIDlet project deployment consists of Application JAR and JAD files.
	 * 
	 * @param projectName
	 * @param projectData
	 * @param resources
	 * @param targetFolder
	 * @param type
	 * @param natureId
	 * @param monitor
	 * @return
	 */
	public Deployment createDeployment(String projectName, Project projectData, IResource[] resources,
			IFolder targetFolder, DeploymentType type, String natureId, IProgressMonitor monitor) throws MtjException;

	public void setMidletProperties(Properties midletProperties);
}
