/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.rpm.ui.preferences;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mtj.extension.rpm.ui.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ModifyDeviceComposite extends Composite {
	private Label rpName;
	private Label deviceName;
	
	//private Text rpDescription;
	private CheckboxTableViewer optionalApiTableViewer;
	
	private Group profileGroup;
	private Group configGroup;
	private Group serviceGroup;
	
	public CheckboxTableViewer getOptionalApiTableViewer() {
		return optionalApiTableViewer;
	}
	
	public Label getRPNameLabel() {
		return rpName;
	}

	public Label getDeviceNameLabel() {
		return deviceName;
	}
	
	public Group getProfileGroup() {
		return profileGroup;
	}

	public Group getServiceGroup() {
		return serviceGroup;
	}
	
	public Group getConfigGroup() {
		return configGroup;
	}
	
	public ModifyDeviceComposite(Composite parent) {
		super(parent, SWT.NONE);		
		setLayout(new GridLayout());
		setLayoutData(new GridData(GridData.FILL_BOTH));
		
		createRuntimeSelectionArea();
		createRuntimeDataArea();
	}
	
	private void createRuntimeDataArea(){
		createApiGroups(this);		
	}

	private void createApiTableViewer(Composite parent) {
		this.optionalApiTableViewer = (CheckboxTableViewer)createTable(parent, SWT.CHECK);
	}
	
	private void createApiGroups(Composite parent){		
		//Device Profile
		profileGroup = createDefaultGroup(parent, 2, false);
		profileGroup.setText(Messages.ModifyDeviceComposite_Profiles);
	
		//Device Configuration
		configGroup = createDefaultGroup(parent, 2, false);
		configGroup.setText(Messages.ModifyDeviceComposite_Configurations);
		
		// ServiceApis
		serviceGroup = /*new Group(parent, SWT.FILL);*/ createDefaultGroup(parent, 1, false);
		serviceGroup.setText(Messages.ModifyDeviceComposite_ServiceApis);
		createApiTableViewer(serviceGroup);
	}
	
	public CheckboxTableViewer createTargetDeviceTable(Composite parent) {
		final CheckboxTableViewer deviceTableViewer = (CheckboxTableViewer)createTable(parent, SWT.CHECK);
		return deviceTableViewer;
	}

	protected String[] variableTargetDeviceTableColumnHeaders = {
			Messages.ModifyDeviceComposite_Import, Messages.ModifyDeviceComposite_DeviceName, Messages.ModifyDeviceComposite_DevvicePlatformName 
	};
	
	protected ColumnLayoutData[] variableTargetDeviceTableColumnLayouts = {
			new ColumnWeightData(20), new ColumnWeightData(50), new ColumnWeightData(50)
	};
	
	private static TableViewer createTable(Composite parent, int swtType){		
		//Create table container		
		Composite tableComposite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.numColumns = 1;
		GridData gridData = new GridData(GridData.FILL_BOTH);
		gridData.heightHint = 200;
		gridData.widthHint = 400;
		tableComposite.setLayout(layout);
		tableComposite.setLayoutData(gridData);

		TableViewer platformTableViewer = null;
		Table platformTable = null;
		if(swtType == SWT.CHECK){
			platformTable = new Table(tableComposite, SWT.CHECK | SWT.BORDER
				| SWT.H_SCROLL | SWT.V_SCROLL );
			
			platformTableViewer = new CheckboxTableViewer(platformTable);
		}
		else{
			platformTable = new Table(tableComposite, SWT.BORDER
					| SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE | SWT.FULL_SELECTION);
			
			platformTableViewer = new TableViewer(platformTable);
		}
		
		TableLayout tableLayout2 = new TableLayout();
		platformTable.setLayout(tableLayout2);
		platformTable.setHeaderVisible(true);
		platformTable.setLinesVisible(true);
		platformTable.setFont(parent.getFont());
		gridData = new GridData(GridData.FILL_BOTH);
		
		platformTableViewer.getControl().setLayoutData(gridData);
		
		return platformTableViewer;
	}

	private void createRefreshArea(Composite parent){
		Composite panel = createDefaultComposite(parent, 1, false);
		
		//Refresh button
		final Button refreshButton = createPushButton(panel, Messages.ModifyDeviceComposite_RefreshContents);
	}
	
	public Button createPushButton(Composite parent, String label) {
		Button button = new Button(parent, SWT.PUSH);
		button.setFont(parent.getFont());
		if (label != null){
			button.setText(label);
		}

		return button;	
	}
	
	public Composite createDefaultComposite(Composite parent, int columns, boolean equalWidth) {		
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout(columns, equalWidth);
		composite.setLayout(layout);

		GridData data = new GridData(SWT.FILL, SWT.FILL, true, false);
		composite.setLayoutData(data);

		return composite;
	}

	private void createRuntimeSelectionArea(){		
		Group container = createDefaultGroup(this, 2, false);
		container.setText(Messages.ModifyDeviceComposite_RuntimePlatform);

		createLabel(container, Messages.ModifyDeviceComposite_Name);
		rpName = createLabel(container, ""); //$NON-NLS-1$
		createLabel(container, Messages.ModifyDeviceComposite_Device);
		deviceName = createLabel(container, "");		 //$NON-NLS-1$
	}
	
	public Text createText(Composite parent, boolean editable){	
		Text text = new Text(parent, SWT.SINGLE | SWT.BORDER);
		text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		text.setEditable(editable);
		
		return text;
	}

	public Label createLabel(Composite parent, String text){	
		Label label = new Label(parent, SWT.NONE);
		label.setText(text);
		label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING));
		
		return label;
	}

	public Group createDefaultGroup(Composite parent, int columns, boolean equalWidth) {
		Group group = new Group(parent, SWT.FILL);
		GridLayout layout = new GridLayout(columns, equalWidth);
		group.setLayout(layout);

		GridData data = new GridData(SWT.FILL, SWT.FILL, true, false);
		group.setLayoutData(data);

		return group;
	}
}
