/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.rpm.ui.preferences;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.mtj.extension.rpm.ui.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Text;

public class ModifyRuntimeComposite extends Composite {
	private Group group = null;
	private Group group1 = null;
	private Table table = null;
	private Composite composite = null;
	private Button button = null;
	private Label label = null;
	private Text text = null;
	private Label label1 = null;
	private Text text1 = null;
	private Composite composite1 = null;

	public Button getImportButton() {
		return button;
	}
	
	public Text getNameText() {
		return text;
	}

	public Text getDescriptionText() {
		return text1;
	}
	
	public CheckboxTableViewer getSdkTableViewer() {
		return new CheckboxTableViewer(table);
	} 
	
	public ModifyRuntimeComposite(Shell parent) {
		super(parent, SWT.NONE);
		composite1 = this;
		composite1.setLayout(new GridLayout());
		createComposite1();
		GridData data = new GridData(GridData.FILL_BOTH);
		this.setLayoutData(data);
	}
		
	/**
	 * This method initializes group	
	 *
	 */
	private void createGroup() {
		GridLayout gridLayout = new GridLayout(2,false);
		group = new Group(composite1, SWT.NONE);
		group.setText(Messages.ModifyRuntimeComposite_RuntimePlatform);
		group.setLayout(gridLayout);
		label = new Label(group, SWT.NONE);
		label.setText(Messages.ModifyRuntimeComposite_Name);
		text = new Text(group, SWT.BORDER);
		label1 = new Label(group, SWT.NONE);
		label1.setText(Messages.ModifyRuntimeComposite_Description);
		text1 = new Text(group, SWT.BORDER);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		text.setLayoutData(data);
		text1.setLayoutData(data);
	}

	/**
	 * This method initializes group1	
	 *
	 */
	private void createGroup1() {
		group1 = new Group(composite1, SWT.NONE);
		group1.setText(Messages.ModifyRuntimeComposite_DevicePlatforms);
		group1.setLayout(new GridLayout(2,false));
		createTable();
		createComposite();
	}

	/**
	 * This method initializes table	
	 *
	 */
	private void createTable() {
		table = new Table(group1, SWT.BORDER | SWT.CHECK);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		GridData data = new GridData(GridData.FILL_BOTH);
		table.setLayoutData(data);
	}

	/**
	 * This method initializes composite	
	 *
	 */
	private void createComposite() {
		GridLayout gl = new GridLayout();
		gl.numColumns = 1;
		gl.marginHeight = 2;
		gl.marginWidth = 2;
		gl.horizontalSpacing = 1;
		gl.verticalSpacing = 1;
		
		composite = new Composite(group1, SWT.BORDER);
		button = new Button(composite, SWT.NONE);
		button.setBounds(new org.eclipse.swt.graphics.Rectangle(25,8,113,29));
		button.setText(Messages.ModifyRuntimeComposite_Import);
		
		GridData data2 = new GridData(GridData.FILL_HORIZONTAL);
		button.setLayoutData(data2);

		composite.setLayout(gl);
		composite.setSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		GridData data = new GridData(GridData.FILL_VERTICAL);
		data.widthHint = 60;
		data.heightHint = 100;
		composite.setLayoutData(data);
	}

	/**
	 * This method initializes composite1	
	 *
	 */
	public void createComposite1() {
		createGroup();
		createGroup1();
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		GridData data1 = new GridData(GridData.FILL_BOTH);
		group.setLayoutData(data);
		group1.setLayoutData(data1);
	}
}
